<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

/**
 * Config for custom data for better organization
 */
class RiceData extends BaseConfig
{
    public function __construct()
    {
        helper('path');
    }

    /** Get Menu Links */
    public function getMenuLinks(): array
    {
        // In 'permissions', the first permission is either
        // the permission of the main link item itself (no subroutes)
        // or the permission for the first subroute (w/ subroutes).

        // 'route' is for the main link item.
        // It's optional for items with 'subroutes',
        // but mandatory on singlular item (no subroutes).
        // It's a best practice to set it even if it contains subroutes.

        // 'hidden' is for links that is connected to the main link item
        // but is not shown in the menu (such as links with parameters).

        return [
            'main'          => [
                'Dashboard'     => [
                    'title'         => 'Dashboard',
                    'route'         => base_url(DASHBOARD_SEGMENT),
                    'icon'          => 'bx-home-circle', // https://boxicons.com/
                    'permissions'   => ['admin.access'],
                    'subroutes'     => [],
                    'hidden'        => [],
                ]
            ],
            'Maintenance'   => [
                'User'         => [
                    'title'         => 'User List',
                    'route'         => user_url(),
                    'icon'          => 'bx-group',
                    'permissions'   => [
                        'users.manage',
                        'users.create'
                    ],
                    'subroutes'     => [
                        'User List'         => user_url(),
                        'Add New User'      => user_url('create')
                    ],
                    'hidden'        => [
                        user_url('edit')
                    ],
                ],
                'Branch'      => [
                    'title'         => 'Branch List',
                    'route'         => branch_url(),
                    'icon'          => 'bx-sitemap',
                    'permissions'   => [
                        'branches.manage',
                        'branches.create'
                    ],
                    'subroutes'     => [
                        'Branch List'       => branch_url(),
                        'Add New Branch'    => branch_url('create')
                    ],
                    'hidden'        => [
                        branch_url('edit')
                    ],
                ],
                'Event'        => [
                    'title'         => 'Event List',
                    'route'         => event_url(),
                    'icon'          => 'bx-star',
                    'permissions'   => [
                        'events.manage',
                        'events.create'
                    ],
                    'subroutes'     => [
                        'Event List'       => event_url(),
                        'Add New Event'    => event_url('create')
                    ],
                    'hidden'        => [
                        event_url('edit')
                    ],
                ],
                'Ticket'       => [
                    'title'         => 'Ticket List',
                    'route'         => ticket_url(),
                    'icon'          => 'bx-paperclip',
                    'permissions'   => [
                        'tickets.manage',
                        'tickets.create',
                        'tickets.validate'
                    ],
                    'subroutes'     => [
                        'Ticket List'       => ticket_url(),
                        'Register Ticket'   => ticket_url('register'),
                        'Validate Ticket'   => ticket_url('validation'),
                    ],
                    'hidden'        => [
                        ticket_url('edit')
                    ],
                ],
            ],
            'Others'        => [
                'System Logs'       => [
                    'title'         => 'System Logs',
                    'route'         => log_url(),
                    'icon'          => 'bx-list-ol',
                    'permissions'   => ['logs.manage'],
                    'subroutes'     => [],
                    'hidden'        => [],
                ],
                'Ticket Reports'       => [
                    'title'         => 'Ticket Reports',
                    'route'         => reports_url(),
                    'icon'          => 'bxs-report',
                    'permissions'   => ['admin.access'],
                    'subroutes'     => [],
                    'hidden'        => [],
                ],
                // 'Admin Settings' => [
                //     'title'         => 'Admin Settings',
                //     'route'         => base_url('admin/settings'),
                //     'icon'          => 'bx-wrench',
                //     'permissions'   => ['admin.settings'],
                //     'subroutes'     => [],
                //     'hidden'        => [],
                // ],
            ],
            'My Account'    => [
                'Profile'           => [
                    'title'         => 'Profile',
                    'route'         => profile_url(),
                    'icon'          => 'bx-user',
                    'permissions'   => [],
                    'subroutes'     => [],
                    'hidden'        => [],
                ],
                // 'Settings'          => [
                //     'title'         => 'Settings',
                //     'route'         => settings_url(),
                //     'icon'          => 'bx-cog',
                //     'permissions'   => [],
                //     'subroutes'     => [],
                //     'hidden'        => [],
                // ],
                'Logout'    => [
                    'title'         => 'Logout',
                    'route'         => base_url('logout'),
                    'icon'          => 'bx-power-off',
                    'permissions'   => [],
                    'subroutes'     => [],
                    'hidden'        => [],
                ]
            ]
        ];
    }

    public array $positionDetails = [
        'admin'             => 'Admin',
        'alumni'            => 'Alumni',
        'faculty'           => 'Faculty',
        'staff'             => 'Staff',
        'student'           => 'Student',
        'others'            => 'Others',
    ];

    public array $departmentDetails = [
        'jhs'               => "Junior High School",
        'shs'               => "Senior High School",
        'college'           => "College",
        'graduate studies'  => "Graduate Studies",
        'eteeap'            => "ETEEAP",
        'others'            => "Others"
    ];

    public array $yearDetails = [
        'jhs'               => [7, 8, 9, 10],
        'shs'               => [11, 12],
        'college'           => [1, 2, 3, 4, 5],
        // 'graduate studies'  => [1, 2, 3, 4, 5],
        // 'eteeap'            => [1, 2, 3, 4, 5],
    ];

    public array $strandDetails = [
        "ABM"       => "Accountancy, Business and Management",
        "STEM"      => "Science, Technology, Engineering and Mathematics",
        "HUMSS"     => "Humanities and Social Sciences",
        "GAS"       => "General Academics",
        "HE"        => "Home Economics",
        "IA"        => "Industrial Arts",
        "ICT"       => "Information and Communication Technology",
        "CI"        => "Creative Industries",
        "PA"        => "Performing Arts (Music and Dance)",
        "CSO"       => "Coaching and Sports Officiating",
        "Others"    => "Others"
    ];

    public array $courseDetails = [
        "BEEd"      => "Bachelor of Elementary Educations",
        "BPEd"      => "Bachelor in Physical Education",
        "BSA"       => "Bachelor of Science in Accountancy",
        "BSBA"      => "Bachelor of Science in Business Administration",
        "BSC"       => "Bachelor of Science in Criminology",
        "BSCS"      => "Bachelor of Science in Computer Science",
        "BSEd"      => "Bachelor of Secondary in Education",
        "BSHM"      => "Bachelor of Science in Hospitality Management",
        "BSIT"      => "Bachelor of Science in Information Technology",
        "BSM"       => "Bachelor of Science in Midwifery",
        "BSMLS"     => "Bachelor of Science in Medical Laboratory Science",
        "BSMT"      => "Bachelor of Science Medical Technology",
        "BSN"       => "Bachelor of Science in Nursing",
        "BSP"       => "Bachelor of Science in Pharmacy",
        "BSPT"      => "Bachelor of Science Physical Therapy",
        "BSRT"      => "Bachelor of Science in Radiologic Technology",
        "BSTM"      => "Bachelor of Science in Tourism Management",

        "AB PolSci" => "Bachelor of Arts in Political Science",
        "AB Pysch"  => "Bachelor of Arts in Psychology",
        "AB English" => "Bachelor of Arts in English",
        "Others"    => "Others"
    ];

    public array $eteeapCourseDetails = [
        "BSN"       => "Bachelor of Science in Nursing",
        "BSBA-MM"   => "Bachelor of Science in Business Administration Major in Marketing Management",
        "BSBA-FM"   => "Bachelor of Science in Business Administration major in Financial Management",
        "BSBA-HRM"  => "Bachelor of Science in Business Administration major in Human Resource Management",
        "BSBA-OM"   => "Bachelor of Science in Business Administration major in Operations Management",
        "BSHM"      => "Bachelor of Science in Hospitality Management",
        "BSTM"      => "Bachelor of Science in Tourism Management",
        "BSCS"      => "Bachelor of Science in Computer Science",
        "BEEd"      => "Bachelor of Elementary Educations",
        "Others"    => "Others"
    ];

    public array $trackCatergory = [
        'student'       => [
            'shs'       => 'strand',
            'college'   => 'course',
            // 'eteeap'    => 'course',
        ]
    ];

    public array $yearCatergory = [
        'student'       => [
            'jhs'       => 'grade level',
            'shs'       => 'grade level',
            'college'   => 'year level',
            // 'eteeap'    => 'year level',
        ]
    ];

    // Position List
    public function getPositionList($key = null): array
    {
        if ($key == null) {
            return $this->positionDetails ?? [];
        }

        return $this->positionDetails[$key] ?? [];
    }

    // Department List based on position
    public function getDepartmentList($position): array
    {
        $departments = [
            'faculty'   => $this->departmentDetails,
            'student'   => $this->departmentDetails,
        ];

        // if ($position == null) {
        //     return $departments ?? [];
        // }

        return $departments[$position] ?? [];
    }

    // Year List based on department
    public function getYearList($position, $department): array
    {
        $years = [
            'student'   => $this->yearDetails,
        ];

        // if ($position == null) {
        //     return $years;
        // } elseif ($department == null) {
        //     return $years[$position];
        // }

        return $years[$position][$department] ?? [];
    }

    // Track List based on department
    public function getTrackList($position, $department, $track = null): array
    {
        $tracks = [
            'student'   => [
                'shs'       => $this->strandDetails,
                'college'   => $this->courseDetails,
                // 'eteeap'    => $this->eteeapCourseDetails,
            ]
        ];

        // if ($position == null) {
        //     return $tracks;
        // } elseif ($department == null) {
        //     return $tracks[$position];
        // } elseif ($track == null) {
        //     return $tracks[$position][$department];
        // }

        if ($track == null) {
            return $tracks[$position][$department] ?? [];
        }

        return $tracks[$position][$department][$track];
    }

    public function getYearAndTrackList($position, $department): array
    {
        return [
            'years'         => $this->getYearList($position, $department),
            'tracks'        => $this->getTrackList($position, $department),
            'yearLabel'     => $this->getYearCategory($position, $department),
            'trackLabel'    => $this->getTrackCategory($position, $department),
        ];
    }

    public function getYearCategory($position, $department): ?string
    {
        return $this->yearCatergory[$position][$department] ?? null;
    }

    public function getTrackCategory($position, $department): ?string
    {
        return $this->trackCatergory[$position][$department] ?? null;
    }

    public function getAllSelection()
    {
        return [
            'position'      => $this->positionDetails,
            'department'    => [
                'faculty'   => $this->departmentDetails,
                'student'   => $this->departmentDetails,
            ],
            'year'          => [
                'student'   => $this->yearDetails,
            ],
            'track'         => [
                'student'   => [
                    'shs'       => $this->strandDetails,
                    'college'   => $this->courseDetails,
                    // 'eteeap'    => $this->eteeapCourseDetails,
                ]
            ],
            'yearLabel'     => $this->yearCatergory,
            'trackLabel'    => $this->trackCatergory,
        ];
    }
}
