<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Encryption\Exceptions\EncryptionException;
use CodeIgniter\Exceptions\PageNotFoundException;

class TestController extends BaseController
{
    public function __construct()
    {
        helper(["form", "input", "qrcode"]);

        throw PageNotFoundException::forPageNotFound();
    }

    public function index()
    {
        return decrypt_data('NDZmZDRjZTQ0NDJhZTQzZWU1Njk5Yjg2NzE4Mjc3MTZlZDk3NjJhMGRmMDAyMGNiYzdhNjVjMzM4NTBlMGNiNDk1MmYwZDk1Y2UwYWFhZDU3OGMwMTVhN2FlZmZjYzQ5NTM4MzkyNmQyNDcwYWY0MGQ4MmI4NTkzOGRhNWViZWN2dXhUcDArZGMrT3ZaSHRkT2FobHJKdGpCM2s4TEFFRmM1ZUh5R0NPRWZUN0RSSUJEUm0zRkRMTHA5aGFORC9aQTRRRDlpREFTM2w5bnpVdkdnPT0');
    }

    public function decrypt($code)
    {
        return decrypt_data($code);
    }

    public function verifyTicket($ticketCode)
    {
        try {
            $ticketNumber = decrypt_data($ticketCode);
        } catch (EncryptionException $ex) {
            $ticketNumber = $ticketCode;
        }

        return $ticketNumber;
    }
}
