<?php

if (!function_exists('get_nested_flashdata')) {
    /**
     * Get a nested flashdata value using dot notation.
     *
     * @param string $key The key of the flashdata message using dot notation for nested arrays.
     * @return mixed The value of the nested flashdata or null if not set.
     */
    function get_nested_flashdata(string $key)
    {
        $session = session();
        $keys = explode('.', $key);
        $flashdata = $session->getFlashdata(array_shift($keys));

        foreach ($keys as $k) {
            if (isset($flashdata[$k])) {
                $flashdata = $flashdata[$k];
            } else {
                return null;
            }
        }

        return $flashdata;
    }
}
