<?php

namespace App\Libraries;

use SendGrid;
use SendGrid\Mail\Mail;

class SendGridService
{
    public function sendEmail($to, $subject, $body, $alt = '')
    {
        $email = new Mail();
        $email->setFrom(env('SENDGRID_FROM_EMAIL'), env('SENDGRID_FROM_NAME'));
        $email->setSubject($subject);
        $email->addTo($to);
        $email->addContent("text/html", $body);

        $sendgrid = new SendGrid(env('SENDGRID_API_KEY'));
        $response = $sendgrid->send($email);

        return $response->statusCode();
    }

    public function sendQRCode($to_email, $to_name, $current_event, $qr_url)
    {
        $email = new Mail();
        $email->setFrom(env('SENDGRID_FROM_EMAIL'), env('SENDGRID_FROM_NAME'));
        $email->addTo($to_email, $to_name);
        $email->setTemplateId(env('SENDGRID_TEMPLATE_KEY'));
        $email->addDynamicTemplateDatas([
            'to_name'    => $to_name,
            'event_name' => $current_event,
            'qrcode'    => $qr_url
        ]);

        $sendgrid = new SendGrid(env('SENDGRID_API_KEY'));
        $response = $sendgrid->send($email);

        return $response->statusCode();
    }
}
