<?= $this->extend('layouts/blank') ?>

<?= $this->section('title') ?> <?= lang('Auth.login') ?> <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link rel="stylesheet" href="/assets/template/vendor/css/pages/page-auth.css" />

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner">
            <!-- Register -->
            <div class="card">
                <div class="card-body">
                    <!-- Logo -->
                    <div class="d-flex align-items-center justify-content-center gap-3 mb-4">
                        <img src="/assets/img/au_logo.png" alt="AU Logo" width="64" />
                        <div class="d-flex flex-column">
                            <h2 class="fw-bold mb-0">auticket</h2>
                            <h6 class="mb-0">Event Management System</h6>
                        </div>
                    </div>
                    <!-- /Logo -->

                    <form class="mb-3" action="<?= url_to('login') ?>" method="POST">
                        <?= csrf_field() ?>

                        <?php $errors = is_array(session('errors')) ? session('errors') : [] ?>
                        <?php $validFields = setting('Auth.validFields') ?>

                        <div class="mb-3">
                            <?php if ($validFields === ['username']) : ?>
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="login" name="login" placeholder="Enter your username" value="<?= old('login') ?>" autofocus />
                            <?php else : ?>
                                <label for="email" class="form-label">Email<?= in_array('username', $validFields) ? ' or username' : '' ?></label>
                                <input type="<?= $validFields === ['email'] ? 'email' : 'text' ?>" class="form-control" id="login" name="login" placeholder="Enter your email<?= in_array('username', $validFields) ? ' or username' : '' ?>" value="<?= old('login') ?>" autofocus />
                            <?php endif ?>

                            <div class="text-danger mt-1">
                                <small>
                                    <?= session('error') ?: dot_array_search('login', $errors) ?: dot_array_search('email', $errors) ?: dot_array_search('username', $errors) ?>
                                </small>
                            </div>

                        </div>
                        <div class="mb-3 form-password-toggle">
                            <div class="d-flex justify-content-between">
                                <label class="form-label" for="password">Password</label>
                                <?php if (setting('Auth.allowRegistration') && setting('Auth.allowMagicLinkLogins')) : ?>
                                    <a href="<?= url_to('magic-link') ?>">
                                        <small>Forgot Password?</small>
                                    </a>
                                <?php endif ?>
                            </div>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control" name="password" placeholder="Enter your password" aria-describedby="password" />
                                <span class="input-group-text"><i class="bx bx-hide"></i></span>
                            </div>
                            <div class="text-danger mt-1">
                                <small><?= session('error') ? null : dot_array_search('password', $errors) ?></small>
                            </div>
                        </div>

                        <?php if (setting('Auth.sessionConfig')['allowRemembering']) : ?>
                            <div class="mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember" <?= old('remember') ? 'checked' : '' ?> />
                                    <label class="form-check-label" for="remember">Remember me</label>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="mb-3">
                            <button class="btn btn-danger d-grid w-100" type="submit"><?= lang('Auth.login') ?></button>
                        </div>
                    </form>

                    <?php if (setting('Auth.allowRegistration')) : ?>
                        <p class="text-center">
                            <span><?= lang('Auth.needAccount') ?></span>
                            <a href="<?= url_to('register') ?>">
                                <span><?= lang('Auth.register') ?></span>
                            </a>
                        </p>
                    <?php elseif (setting('Auth.allowMagicLinkLogins')) : ?>
                        <p class="text-center">
                            <span><?= lang('Auth.forgotPassword') ?></span>
                            <a href="<?= url_to('magic-link') ?>">
                                <span><?= lang('Auth.useMagicLink') ?></span>
                            </a>
                        </p>
                    <?php endif ?>
                </div>
            </div>
            <!-- /Register -->
        </div>
    </div>
</div>

<?= $this->endSection() ?>