<?= $this->extend('layouts/blank') ?>

<?= $this->section('title') ?> <?= lang('Auth.register') ?> <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link rel="stylesheet" href="/assets/template/vendor/css/pages/page-auth.css" />

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-center gap-3 mb-4">
                        <img src="/assets/img/au_logo.png" alt="AU Logo" width="64" />
                        <div class="d-flex flex-column">
                            <h2 class="fw-bold mb-0">auticket</h2>
                            <h6 class="mb-0">Event Management System</h6>
                        </div>
                    </div>

                    <form class="mb-3" action="<?= url_to('register') ?>" method="POST">
                        <?= csrf_field() ?>

                        <?php $errors = is_array(session('errors')) ? session('errors') : [] ?>

                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="username" name="username" placeholder="Enter your username" value="<?= old('username') ?>" autofocus />
                            <div class="text-danger mt-1">
                                <small>
                                    <?= session('error') ?: dot_array_search('username', $errors) ?>
                                </small>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="" class="form-control" id="email" name="email" placeholder="Enter your email" value="<?= old('email') ?>" />
                            <div class="text-danger mt-1">
                                <small>
                                    <?= session('error') ? null : dot_array_search('email', $errors) ?>
                                </small>
                            </div>
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <label class="form-label" for="password">Password</label>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control" name="password" placeholder="Enter your password" aria-describedby="password" />
                                <span class="input-group-text"><i class="bx bx-hide"></i></span>
                            </div>
                            <div class="text-danger mt-1">
                                <small><?= session('error') ? null : dot_array_search('password', $errors) ?></small>
                            </div>
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <label class="form-label" for="password_confirm">Confirm Password</label>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password_confirm" class="form-control" name="password_confirm" placeholder="Confirm password" aria-describedby="password" />
                                <span class="input-group-text"><i class="bx bx-hide"></i></span>
                            </div>
                            <div class="text-danger mt-1">
                                <small><?= session('error') ? null : dot_array_search('password_confirm', $errors) ?></small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <button class="btn btn-danger d-grid w-100" type="submit"><?= lang('Auth.register') ?></button>
                        </div>
                    </form>

                    <p class="text-center">
                        <span><?= lang('Auth.haveAccount') ?></span>
                        <a href="<?= url_to('login') ?>">
                            <span><?= lang('Auth.login') ?></span>
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>