<script src="/assets/vendor/Select2/select2.min.js"></script>
<script type="text/javascript">
    (function() {
        $('.select2').each(function() {
            let config = {
                theme: 'bootstrap-5'
            };

            let hint = $(this).attr('data-hint');

            if (typeof hint !== "undefined") {
                config.placeholder = hint;
                config.allowClear = true;

                if ($(this).has('option[value=""]')) {
                    $(this).find('option[value=""]').text("");
                } else {
                    $(this).prepend('<option></option>');
                }
            }

            if ($(this).hasClass('form-select')) {
                $(this).removeClass('form-select');
            }

            $(this).select2(config);
        });
    })();

    $.fn.Select2UpdatePlaceholder = function(newPlaceholder) {
        var $select2 = $(this).data('select2');
        $select2.selection.placeholder.text = newPlaceholder;
        return $select2.$container.find('.select2-selection__placeholder').text(newPlaceholder);
    };

    $.fn.Select2GetPlaceholder = function() {
        var $select2Container = $(this).data('select2').$container;
        return $select2Container.find('.select2-selection__placeholder').text();
    };
</script>