<div class="nav-bg sticky-top">

    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="d-flex align-items-center flex-fill position-relative">
                <div class="d-flex align-items-center flex-fill">
                    <?php if (isset($searchbar) && $searchbar === true) : ?>
                        <i class="bx bx-search fs-4 lh-0"></i>
                        <input type="search" name="searchbar" id="searchbar" class="form-control border-0 shadow-none bg-transparent" placeholder="Search<?= $this->renderSection('entity') ?>" aria-label="Search..." />
                    <?php else : ?>
                        <h4 class="m-0"><?= $module ?? 'Management' ?></h4>
                    <?php endif ?>
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">

                <?= $this->renderSection('navbar-items') ?>

                <!-- User -->
                <?php if (auth()->loggedIn()) : $user = auth()->user() ?>
                    <li class="nav-item navbar-dropdown dropdown-user dropdown">
                        <a class="nav-link dropdown-toggle" role="button" data-bs-toggle="dropdown">
                            @<span class="d-none d-sm-inline"><?= $user->username ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="<?= profile_url() ?>">
                                    <div class="d-flex">
                                        <div class="flex-grow-1">
                                            <span class="fw-semibold d-block">
                                                <?= view('partials/elements/common/name', [
                                                    'first_name'    => $user->first_name,
                                                    'last_name'     => $user->last_name,
                                                ]) ?>
                                            </span>
                                            <div class="text-muted">
                                                <small class="text-muted">
                                                    <span class="d-inline d-sm-none"><?= "@{$user->username} | " ?></span>
                                                    <?= $user->getGroups()[0] ?>
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <div class="dropdown-divider"></div>
                            </li>
                            <!-- <li>
                                <a class="dropdown-item" href="<?= profile_url() ?>">
                                    <i class="bx bx-user me-2"></i>
                                    <span class="align-middle">My Profile</span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?= settings_url() ?>">
                                    <i class="bx bx-cog me-2"></i>
                                    <span class="align-middle">Settings</span>
                                </a>
                            </li>
                            <li>
                                <div class="dropdown-divider"></div>
                            </li> -->
                            <li>
                                <a class="dropdown-item text-danger" href="<?= base_url('logout') ?>">
                                    <i class="bx bx-power-off me-2"></i>
                                    <span class="align-middle">Log Out</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php else : ?>
                    <li class="nav-item navbar-dropdown dropdown-user dropdown">
                        <a class="nav-link dropdown-toggle" role="button" data-bs-toggle="dropdown">
                            @<span class="d-none d-sm-inline">Not Logged In</span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item <?= !setting('Auth.allowRegistration') ? 'disabled' : '' ?>" href="<?= base_url('register') ?>">
                                    <i class="bx bxs-user-plus me-2"></i>
                                    <span class="align-middle">Create Account</span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?= base_url('login') ?>">
                                    <i class="bx bx-log-in me-2"></i>
                                    <span class="align-middle">Log In</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php endif ?>

                <!--/ User -->
            </ul>
        </div>
    </nav>
</div>