<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Profile <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link href="/assets/vendor/DataTables/datatables.css" rel="stylesheet">

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?php $user = auth()->user() ?>

<div class="row">
    <div class="col-md-8">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <h5 class="card-header">Profile Details</h5>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="text-bold">Name</div>
                            <div>
                                <?= view('partials/elements/common/name', [
                                    'first_name'    => $user->first_name,
                                    'middle_name'   => $user->middle_name,
                                    'last_name'     => $user->last_name
                                ]) ?>
                            </div>
                            <small>@<?= $user->username ?></small>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Email</div>
                            <div>
                                <?= $user->email ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Phone Number</div>
                            <div>
                                <?= $user->phone_number ?? 'No Number' ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Branch</div>
                            <div>
                                <?php
                                if ($user->branch_id && $branch = model('BranchModel')->find($user->branch_id)) {
                                    echo $branch->branch_name;
                                } else {
                                    echo 'No Branch';
                                }
                                ?>
                            </div>
                        </div>
                        <div class="d-flex gap-2 row-gap-2 flex-wrap mt-4">

                            <button type="button" class="btn btn-primary flex-fill flex-sm-grow-0" data-bs-toggle="modal" data-bs-target="#updateProfileModal">
                                Update Profile
                            </button>
                            <button type="button" class="btn btn-danger flex-fill flex-sm-grow-0" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                                Change Password
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">Logged Activities</h5>
                    <div id="table_container" class="">
                        <table id="log_table" class="table table-striped nowrap" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th class="col_date">Date</th>
                                    <th class="col_desc">Description</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">History</h5>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="text-bold">Date Created</div>
                            <div>
                                <?= $user->created_at ? date("Y-M-d | h:i A", strtotime($user->created_at)) : "Unknown" ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Last Updated</div>
                            <div>
                                <?= $user->updated_at ? date("Y-M-d | h:i A", strtotime($user->updated_at)) : "Not Update" ?>
                            </div>
                        </div>
                        <?php if ($showCreator && $user->created_by && $creator = model('UserModel')->find($user->created_by)) : ?>
                            <div class="mb-3">
                                <div class="text-bold">Created By</div>
                                <div>
                                    <?= view('partials/elements/common/name', [
                                        'first_name'    => $creator->first_name,
                                        'middle_name'   => $creator->middle_name,
                                        'last_name'     => $creator->last_name
                                    ]) ?>
                                </div>
                            </div>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="updateProfileModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form id="updateProfile" class="modal-content" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Update Profile</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row gx-2 gy-3">
                    <div class="col-md-4">
                        <label for="first_name" class="form-label">First Name</label>
                        <input type="text" name="first_name" id="first_name" class="form-control text-capitalize" placeholder="First Name" data-initial="<?= esc($user->first_name) ?>" value="<?= esc($user->first_name) ?>" />
                        <small class="text-danger" data-content="error" data-for="first_name"></small>
                    </div>
                    <div class="col-md-4">
                        <label for="first_name" class="form-label">Last Name</label>
                        <input type="text" name="last_name" id="last_name" class="form-control text-capitalize" placeholder="Last Name" data-initial="<?= esc($user->last_name) ?>" value="<?= esc($user->last_name) ?>" />
                        <small class="text-danger" data-content="error" data-for="last_name"></small>
                    </div>
                    <div class="col-md-4">
                        <label for="first_name" class="form-label">Middle Name (Optional)</label>
                        <input type="text" name="middle_name" id="middle_name" class="form-control text-capitalize" placeholder="Middle Name (Optional)" data-initial="<?= esc($user->middle_name) ?>" value="<?= esc($user->middle_name) ?>" />
                        <small class="text-danger" data-content="error" data-for="middle_name"></small>
                    </div>
                    <div class="col-md-4">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" name="username" id="username" class="form-control" placeholder="Username" data-initial="<?= esc($user->username) ?>" value="<?= esc($user->username) ?>" />
                        <small class="text-danger" data-content="error" data-for="username"></small>
                    </div>
                    <div class="col-md-8">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" name="email" id="email" class="form-control" placeholder="Email" data-initial="<?= esc($user->email) ?>" value="<?= esc($user->email) ?>" />
                        <small class="text-danger" data-content="error" data-for="email"></small>
                    </div>
                    <div class="col-md-4">
                        <label for="phone_number" class="form-label">Phone Number</label>
                        <input type="text" name="phone_number" id="phone_number" class="form-control" placeholder="Phone Number" data-initial="<?= esc($user->phone_number) ?>" value="<?= esc($user->phone_number) ?>" />
                        <small class="text-danger" data-content="error" data-for="phone_number"></small>
                    </div>
                    <div class="col-md-8">
                        <label for="branch_id" class="form-label">Branch</label>
                        <select name="branch_id" id="branch_id" class="form-select select2" data-initial="<?= esc($user->branch_id) ?>">
                            <option value="">Select a branch</option>
                            <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                <option value="<?= $branch->id ?>" <?= $branch->id === old('branch_id', $user->branch_id) ? 'selected' : '' ?>><?= $branch->branch_name ?></option>
                            <?php endforeach ?>
                        </select>
                        <small class="text-danger" data-content="error" data-for="branch_id"></small>
                    </div>
                </div>
            </div>
            <div class="modal-footer" data-content="actions">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Cancel
                </button>
                <button type="submit" class="btn btn-primary">
                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    Save Profile
                </button>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="changePasswordModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <form id="changePassword" class="modal-content" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Change Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row gx-2 gy-3">
                    <div class="col-12 form-password-toggle">
                        <label for="old_password" class="form-label">Old Password</label>
                        <div class="input-group input-group-merge">
                            <input type="password" name="old_password" id="old_password" class="form-control" placeholder="Enter Old Password" aria-describedby="password" />
                            <span class="input-group-text"><i class="bx bx-hide"></i></span>
                        </div>
                        <small class="text-danger" data-content="error" data-for="old_password"></small>
                    </div>
                    <div class="col-12 form-password-toggle">
                        <label for="password" class="form-label">New Password</label>
                        <div class="input-group input-group-merge">
                            <input type="password" name="password" id="password" class="form-control" placeholder="Enter New Password" aria-describedby="password" />
                            <span class="input-group-text"><i class="bx bx-hide"></i></span>
                        </div>
                        <small class="text-danger" data-content="error" data-for="password"></small>
                    </div>
                    <div class="col-12 form-password-toggle">
                        <label for="password_confirm" class="form-label">Confirm Password</label>
                        <div class="input-group input-group-merge">
                            <input type="password" name="password_confirm" id="password_confirm" class="form-control" placeholder="Confirm Password" aria-describedby="password" />
                            <span class="input-group-text"><i class="bx bx-hide"></i></span>
                        </div>
                        <small class="text-danger" data-content="error" data-for="password_confirm"></small>
                    </div>
                </div>
            </div>
            <div class="modal-footer" data-content="actions">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Cancel
                </button>
                <button type="submit" class="btn btn-primary">
                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    Save Password
                </button>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/vendor/DataTables/datatables.js"></script>
<script src="/assets/js/dt_swal2_init.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var dataTable = init_dt_serverside({
            table: "#log_table",
            <?= (ENVIRONMENT !== 'production') ? 'debug: true' : 'debug: false' ?>,
            url: "<?= profile_url('activity') ?>",
            type: 'GET',
            data: function(d) {
                <?= (ENVIRONMENT !== 'production') ? 'console.log("Parameters:", d);' : '' ?>
            },
            columns: [{
                    data: 'timestamp',
                    name: 'timestamp',
                },
                {
                    data: 'description',
                    className: "text-wrap",
                    name: 'action',
                    responsivePriority: 1,
                    orderable: false,
                }
            ],
            columnDefs: [{
                    targets: '_all',
                    className: 'dt-head-left dt-body-left align-middle',
                },
                // {
                //     target: 'col_desc',
                //     className: 'col-emphasis',
                // }
            ],
            rows: 5,
            sort: {
                name: 'timestamp',
                dir: 'desc',
            },
            select: false,
            createdRow: false,
            rowId: "timestamp"
        });

        $('#updateProfileModal, #changePasswordModal').on('hidden.bs.modal', function(e) {
            $('[data-content="error"]').text('');
            $(this).find("input, select, textarea").each(function() {
                $(this).val($(this).attr('data-initial'));
            });
        });

        $('#updateProfile').on('submit', function(e) {
            e.preventDefault();

            disableButtons('#updateProfile', true, true);
            let formData = $(this).serialize();
            let config = initAjax(
                '#updateProfile',
                '<?= profile_url('update') ?>',
                formData
            );
            $.ajax(config);
        });

        $('#changePassword').on('submit', function(e) {
            e.preventDefault();

            disableButtons('#changePassword', true, true);
            let formData = $(this).serialize();
            let config = initAjax(
                '#changePassword',
                '<?= profile_url('update/password') ?>',
                formData,
                '#changePasswordModal'
            );
            $.ajax(config);
        });

        function initAjax(form, url, data, modalClose = '') {
            return {
                url: url,
                method: "post",
                data: data,
                dataType: "json",
                success: function(response) {
                    console.log(response);
                    if (response.success) {
                        Swal.fire({
                            title: response.data,
                            timer: 1500,
                            icon: 'success',
                            didOpen: () => {
                                const timer = Swal.getPopup().querySelector("b");
                                timerInterval = setInterval(() => {
                                    timer.textContent = `${Swal.getTimerLeft()}`;
                                }, 100);
                            },
                            willClose: () => {
                                clearInterval(timerInterval);
                            }
                        }).then((result) => {
                            if (result.isConfirmed || result.dismiss === Swal.DismissReason.timer) {
                                if (modalClose === '') {
                                    window.location.reload();
                                } else {
                                    $(modalClose).modal('hide');
                                }
                            }
                        });
                    } else {
                        if (response.data !== null) {
                            let data = response.data;
                            Swal.fire({
                                title: "Something went wrong...",
                                html: typeof data === "object" ?
                                    `<ul>${Object.entries(data)
                                    .map(([key, value]) =>
                                    value !== null && value !== "" ? `<li>${value}</li>` : ""
                                    )
                                    .join("")}</ul>` : data,
                                icon: "error"
                            });
                        }

                        if (response.errors !== null) {
                            $.each(response.errors, function(key, value) {
                                setError(key, value);
                            });
                        }

                        disableButtons(form, false, false);
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        title: "Error",
                        html: content.errorText,
                        icon: "error",
                    });
                    console.error("An error occurred: " + error);
                    disableButtons(form, false, false);
                }
            };
        }

        function disableButtons(formId, value = true, processing = false) {
            $buttons = $(`${formId} [data-action='actions']`);
            $buttons.find("button").prop("disabled", value);
            if (processing === true) {
                $buttons
                    .find('button[type="submit"] #submit_spinner')
                    .removeClass("d-none");
            } else {
                $buttons.find('button[type="submit"] #submit_spinner').addClass("d-none");
            }
        }

        $("form")
            .find("input, select, textarea")
            .on("input change", function() {
                setError($(this).attr("name"), "");
            });

        function setError(field, text = "") {
            $(`[data-content="error"][data-for="${field}"]`).text(text);
        }
    });
</script>

<?= $this->endSection() ?>