<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Profile <?= $this->endSection() ?>

<?= $this->section('content') ?>

<?php $user = auth()->user() ?>

<div class="row">
    <div class="col-md-8">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <h5 class="card-header">Profile Details</h5>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="text-bold">Name</div>
                            <div>
                                <?= view('partials/elements/common/name', [
                                    'first_name'    => $user->first_name,
                                    'middle_name'   => $user->middle_name,
                                    'last_name'     => $user->last_name
                                ]) ?>
                            </div>
                            <small>@<?= $user->username ?></small>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Email</div>
                            <div>
                                <?= $user->email ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Phone Number</div>
                            <div>
                                <?= $user->phone_number ?? 'No Number' ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Branch</div>
                            <div>
                                <?= $user->branch_id ? model('BranchModel')->find($user->branch_id)?->branch_name : 'No Branch' ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">Logged Activities</h5>
                    <table class="table table-compact table-striped">
                        <caption>List of Logged Activities</caption>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (model('LogModel')->where('performed_by', $user->id)->orderBy('timestamp', 'desc')->find() as $log) : ?>
                                <tr>
                                    <td class="text-nowrap"><?= date("Y-M-d | h:i:s A", strtotime($log->timestamp)) ?></td>
                                    <td><?= log_descriptor($log) ?></td>
                                </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">History</h5>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="text-bold">Date Created</div>
                            <div>
                                <?= $user->created_at ? date("y-M-d | h:i:s A", strtotime($user->created_at)) : "Unknown" ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="text-bold">Last Updated</div>
                            <div>
                                <?= $user->updated_at ? date("y-M-d | h:i:s A", strtotime($user->updated_at)) : "Not Update" ?>
                            </div>
                        </div>
                        <?php if ($showCreator && $user->created_by && $creator = model('UserModel')->find($user->created_by)) : ?>
                            <div class="mb-3">
                                <div class="text-bold">Created By</div>
                                <div>
                                    <?= view('partials/elements/common/name', [
                                        'first_name'    => $creator->first_name,
                                        'middle_name'   => $creator->middle_name,
                                        'last_name'     => $creator->last_name
                                    ]) ?>
                                </div>
                            </div>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>