<!-- <?= $this->extend('layouts/main') ?> -->

<?= $this->section('title') ?> Ticket List <?= $this->endSection() ?>

<?= $this->section('entity') ?> Ticket <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card mb-3">
    <div class="card-header">

        <?= $this->include('partials/elements/common/alert') ?>

        <div class="row gy-3">
            <div class="col">
                <form id="recordfilter" method="post">
                    <!-- <div class="d-flex justify-content-between gap-2 mb-2">
                        <div class="d-flex align-items-center flex-fill gap-2 row-gap-2">
                            <label for="event" class="d-none d-sm-block">Event:</label>
                            <select class="form-select" data-action="filter" name="event" id="event">
                                <?php foreach (model('EventModel')->findAll() as $event) : ?>
                                    <?php $selected = $event->active ? 'selected' : '' ?>
                                    <option value="<?= $event->id ?>" <?= $selected ?>><?= $event->event_name . ($selected ? ' [ACTIVE]' : '') ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary" tabindex="0">
                                <span><i class="bx bx-outline me-sm-1"></i></span>
                                <span class="d-none d-md-inline-block">Generate Reports</span>
                            </button>
                        </div>
                    </div> -->
                    <div class="d-flex align-items-center gap-2 row-gap-2 flex-wrap">
                        <div class="mb-2">
                            <i class='bx bx-filter'></i>
                        </div>
                        <?php if (auth()->loggedIn() && auth()->user()->can('tickets.view-all')) : ?>
                            <div class="flex-fill flex-md-grow-0">
                                <select class="form-select" data-action="filter" name="branch" id="branch">
                                    <option value="">All Branch</option>
                                    <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                        <option value="<?= $branch->id ?>"><?= $branch->branch_name ?></option>
                                    <?php endforeach ?>
                                </select>
                            </div>
                        <?php endif ?>
                        <!-- <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="position" id="position">
                                <option value="">All Position</option>
                                <?php foreach (setting('RiceData.positionDetails') as $position => $desc) : ?>
                                    <option value="<?= $position ?>"><?= $desc ?></option>
                                <?php endforeach ?>
                            </select>
                        </div> -->
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="department" id="department">
                                <option value="">All Department</option>
                                <?php foreach (setting('RiceData.departmentDetails') as $department => $desc) : ?>
                                    <option value="<?= $department ?>"><?= $desc ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <!-- <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="requirements" id="requirements">
                                <option value="">All Requirement Status</option>
                                <option value="1">Submitted</option>
                                <option value="0">Not Submitted</option>
                            </select>
                        </div> -->
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="type" id="type">
                                <option value="">All Type</option>
                                <option value="1">Attendees Only</option>
                                <option value="2">Early Out Attendees</option>
                                <option value="3">Not Attended</option>
                                <option value="4">Rqmts. Submitted</option>
                                <option value="5">Rqmts. Not Submitted</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-auto">
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" id="generate" tabindex="0">
                        <span><i class="bx bx-outline me-sm-1"></i></span>
                        <span class="">Generate</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card d-none" id="reportContainer">
    <div class="card-header">
        <div class="d-flex justify-content-end flex-wrap gap-2 row-gap-2">
            <button type="button" id="printBtn" class="btn btn-outline-secondary" tabindex="0">
                <span><i class="bx bx-printer me-sm-1"></i></span>
                <span class="d-inline-block">Print</span>
            </button>
            <!-- <button type="button" class="btn btn-primary" tabindex="0">
                <span><i class="bx bx-file me-sm-1"></i></span>
                <span class="d-inline-block">Export as PDF</span>
            </button> -->
        </div>
    </div>
    <div class="card-body">
        <div class="overflow-auto" id="reportFrame"></div>
        <!-- <iframe src="" frameborder="0" id="report_iframe" class="w-100" height="500"></iframe> -->
    </div>
</div>



<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#generate').click(function(event) {
            event.preventDefault();

            // Serialize the form data
            var formData = $('form#recordfilter').serialize();

            // Perform the AJAX request
            $.ajax({
                url: '<?= base_url(REPORT_SEGMENT . '/retrieve') ?>',
                type: 'POST',
                data: formData,
                success: function(response) {
                    // $('#report_iframe').ready(function() {
                    //     $('#report_iframe').contents().find("body").empty().append(response);
                    // });
                    $('#reportFrame').html(response);
                    $("#reportContainer").removeClass('d-none');
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        });

        $('#printBtn').click(function() {
            var content = $('#reportFrame').html();
            var noScript = $('noscript').clone().append(content);
            var newWindow = window.open("Report", "_blank", "width=900,height=700");
            newWindow.document.write(noScript.html());
            newWindow.document.close();
            newWindow.onload = function() {
                newWindow.print();
                setTimeout(function() {
                    newWindow.close();
                }, 100);
            };
        });
    });
</script>

<noscript>
    <style>
        <?= preg_replace('#[\r\n\t ]+#', ' ', file_get_contents(__DIR__ . DIRECTORY_SEPARATOR . 'print.css')) ?>
    </style>
</noscript>

<?= $this->endSection() ?>