<div class="table-con my-4">
    <table class="table">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Name</th>
                <th scope="col">Position</th>
                <th scope="col">Rqmts. Status</th>
                <th scope="col">Time Attended</th>
                <th scope="col">Early Time Leaved</th>
            </tr>
        </thead>
        <tbody>
            <?php $rowCount = 0 ?>
            <?php foreach ($tickets as $ticket) : ?>
                <tr>
                    <th scope="row"><?= ++$rowCount ?></th>
                    <td>
                        <?= esc("{$ticket->first_name} {$ticket->last_name}") ?> <br />
                        <small><?= esc($ticket->email) ?></small>
                    </td>
                    <td>
                        <span style="text-transform: uppercase;"><?= esc("{$ticket->department} {$ticket->position}") ?></span> <br />
                        <small><?= esc($year ? ($track ? "{$year}-{$track}" : "Grade {$year}") : $track ?? "") ?></small>
                    </td>
                    <td>
                        <?= $ticket->req_submitted ? "Submitted" : "Not Submitted" ?>
                    </td>
                    <td>
                        <?= esc($ticket->date_attend ?? '~')  ?>
                    </td>
                    <td>
                        <?= esc($ticket->date_leave ?? '~') ?>
                    </td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>
</div>
<div class="summary">
    <table class="table mb-5" style="max-width: 300px">
        <tr>
            <th>Attendees</th>
            <td>19</td>
        </tr>
        <tr>
            <th>Did not attend</th>
            <td>1</td>
        </tr>
        <tr>
            <th>Total</th>
            <td>20</td>
        </tr>
        <tr>
            <th>Early Outs</th>
            <td>14</td>
        </tr>
    </table>
</div>
<div class="note">
    <p>Retrieved By</p>
    <p>
        <strong>Dan Maurice B. Balderama</strong> <br />
        <small style="font-style: italic;">danmauricebalderama44@gmail.com</small>
    </p>
</div>