<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Validate Ticket <?= $this->endSection() ?>

<?= $this->section('entity') ?> Ticket to Validate <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card mb-4">
    <div class="card-body py-3">
        <form id="search" method="post">
            <div class="row mb-3">
                <label class="col-sm-3 col-md-2 col-form-label" for="ticketCode">Ticket Number/QR Code</label>
                <div class="col-sm-9 col-md-10">
                    <input autocomplete="off" type="text" name="ticketCode" class="form-control" id="ticketCode" placeholder="Enter Ticket Number/QR Code" data-clearable="true" value="<?= $ticket_code ?>" autofocus disabled />
                    <small class="text-danger" id="search_error" data-clearable="true"></small>
                </div>
            </div>
            <div class="row justify-content-end">
                <div class="col-sm-9 col-md-10">
                    <div class="d-flex align-items-center gap-2">
                        <button type="button" class="btn btn-outline-secondary" id="btnclear" disabled>Clear</button>
                        <button type="submit" class="btn btn-primary" id="btnsearch" disabled>Search</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row d-none" id="info_block">
    <div class="col-12 col-md-8">
        <div class="card mb-4">
            <h4 class="card-header bg-primary text-white py-2">
                <i class='bx bxs-badge-check'></i>
                Ticket Details
            </h4>
            <div class="card-body py-3">
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="ticketNumber">Ticket Number</div>
                    <div class="col-sm-9 fw-bold" id="ticketNumber" data-clearable="true"></div>
                </div>
                <hr>
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="eventName">Event</div>
                    <div class="col-sm-9 fw-bold" id="eventName" data-clearable="true"></div>
                </div>
                <hr>
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="branch">Branch</div>
                    <div class="col-sm-9 fw-bold" id="branch" data-clearable="true"></div>
                </div>
                <hr>
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="fullname">Name</div>
                    <div class="col-sm-9 fw-bold" id="fullname" data-clearable="true"></div>
                </div>
                <hr>
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="idNumber">Valid ID Number</div>
                    <div class="col-sm-9 fw-bold" id="idNumber" data-clearable="true"></div>
                </div>
                <hr>
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="fullname">Position</div>
                    <div class="col-sm-9 fw-bold" id="position" data-clearable="true"></div>
                </div>
                <hr>
                <div class="row ms-1 mb-3">
                    <div class="col-sm-3" data-label-for="requirements">Requirements Status</div>
                    <div class="col-sm-9 fw-bold">
                        <span class="badge bg-success" id="requirements" data-clearable="true"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-4">
        <form id="action" method="post">
            <?= csrf_field() ?>
            <div class="row gy-4">
                <div class="col-12 col-sm-6 col-md-12">
                    <div class="card h-100 mb-4">
                        <h4 class="card-header bg-primary text-white py-2">
                            <i class='bx bxs-time'></i>
                            Time Attended
                        </h4>
                        <div class="card-body py-3">
                            <div class="row mb-3">
                                <div class="col-lg-5" data-label-for="timeAttended">Date/Time</div>
                                <div class="col-lg-7 fw-bold" id="timeAttended" data-clearable="true">Not Yet</div>
                            </div>
                            <div class="d-grid mb-3">
                                <button type="button" data-action="CLOCKIN" class="btn btn-outline-primary" id="btnclockin">
                                    <i class='bx bx-log-in-circle'></i>
                                    <span class="button-text">Time-In</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-sm-6 col-md-12">
                    <div class="card h-100 mb-4">
                        <h4 class="card-header bg-primary text-white py-2">
                            <i class='bx bxs-time'></i>
                            Time Leaved
                        </h4>
                        <div class="card-body py-3">
                            <div class="row mb-3">
                                <div class="col-lg-5" data-label-for="timeLeaved">Date/Time</div>
                                <div class="col-lg-7 fw-bold" id="timeLeaved" data-clearable="true">Not Yet</div>
                            </div>
                            <div class="d-grid mb-3">
                                <button type="button" data-action="CLOCKOUT" class="btn btn-outline-primary" id="btnclockout">
                                    <i class='bx bx-log-out-circle'></i>
                                    <span class="button-text">Time-Out</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="ticketID" id="ticketID" data-clearable="true" />
        </form>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<script type="text/javascript">
    $(document).ready(function() {

        setTimeout(() => {
            $('form#search').find("button, input").prop("disabled", false);
            $('form#search').find("input[autofocus]").focus();

            if ($('#ticketCode').val()) {
                $('form#search').trigger('submit');
            }
        }, 800);

        $('#btnclear').click(function() {

            $(document).find('[data-clearable="true"]').each(function() {
                let $field = $(this);

                if ($field.is('input[type="checkbox"][type="radio"]')) {
                    $field.prop('checked', false);
                } else if ($field.is('input, textarea')) {
                    $field.val('');
                } else {
                    $field.text('');
                }
            });

            $('#info_block').addClass('d-none');
            $('#ticketCode').focus();

        });

        $('form#search').on('submit', function(e) {

            e.preventDefault();

            $.ajax({
                url: '<?= ticket_url('validate') ?>',
                type: 'POST',
                dataType: 'json',
                data: $(this).serialize(),
                success: function(result) {
                    if (result.success) {
                        var data = result.data;

                        $('#ticketID').val(data.ticketID);
                        $('#ticketCode').val(data.ticketNumber);

                        $('#ticketNumber').text(data.ticketNumber);
                        $('#eventName').text(data.eventName);
                        $('#branch').text(data.branch);
                        $('#idNumber').text(data.idNumber);
                        $('#fullname').text(data.fullname);
                        $('#position').text(data.position);

                        updateRequirementsColor(data.requirements);

                        $('#search_error').text('');
                        $('#info_block').removeClass('d-none');

                        // This must be here below to trigger focus on clocking buttons
                        updateTimingButtons(data.requirements, data.timeAttended, data.timeLeaved);

                        $('html, body').animate({
                            scrollTop: $('#ticketNumber').offset().top - 150
                        }, 'fast');
                    } else {
                        $('#search_error').text(result.data);
                        $('#info_block').addClass('d-none');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert('Something went wrong. Please contact admin');
                }
            });
        });

        $('#btnclockin, #btnclockout').click(function() {

            let action = $(this).attr('data-action');
            let formData = $('form#action').serialize() + '&' + $.param({
                action: action
            });

            $.ajax({
                url: '<?= ticket_url('trackTime') ?>',
                type: 'POST',
                dataType: 'json',
                data: formData,
                success: function(result) {
                    if (result.success) {

                        let data = result.data;

                        updateTimingButtons(data.requirements, data.timeAttended, data.timeLeaved, true);

                        $('#info_block').removeClass('d-none');
                        $('#search_error').text('');
                    } else {
                        $('#ticketCode').focus();
                        $('#search_error').text(result.data);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert('Something went wrong. Please contact admin');
                }
            });
        });

        function updateRequirementsColor(submitted) {
            if (submitted == 1) {
                $('#requirements')
                    .text('Submitted')
                    .removeClass('bg-warning')
                    .addClass('bg-success');
            } else {
                $('#requirements')
                    .text('Not Submitted')
                    .removeClass('bg-success')
                    .addClass('bg-warning');
            }
        }

        function updateTimingButtons(reqSubmitted, timeIn, timeOut, clear = false) {

            $('#timeAttended').text('Not Yet');
            $('#timeLeaved').text('Not Yet');

            if (timeIn == null || timeIn == '') {

                if (true /*reqSubmitted == 1*/ ) {

                    // $('#btnclockin')
                    //     .prop('disabled', false)
                    // .focus();

                    // $('#btnclockout')
                    //     .prop('disabled', true);

                    $('#btnclockin')
                        .removeClass('d-none');

                    $('#btnclockout')
                        .addClass('d-none');
                }

                console.log('__timeinbtn_activated__');
            } else if (timeOut == null || timeOut == '') {

                $('#timeAttended').text(timeIn);

                if (true /*reqSubmitted == 1*/ ) {

                    // $('#btnclockin')
                    //     .prop('disabled', true);

                    // $('#btnclockout')
                    //     .prop('disabled', false);
                    // //.focus();

                    $('#btnclockin')
                        .addClass('d-none');

                    $('#btnclockout')
                        .removeClass('d-none');
                }

                console.log('__timeoutbtn_activated__');
            } else {

                $('#timeAttended').text(timeIn);
                $('#timeLeaved').text(timeOut);

                // $('#btnclockin')
                //     .prop('disabled', true);

                // $('#btnclockout')
                //     .prop('disabled', true);

                $('#btnclockin')
                    .addClass('d-none');

                $('#btnclockout')
                    .addClass('d-none');

                console.log('__timebtns_deactivated__');
            }

            if (clear) {
                $('#ticketCode').val('').focus();
            }
        }

        // function updateCurrentUrl(paramToRemove) {
        //     let currentUrl = window.location.href;
        //     let updatedUrl = modifyUrl(currentUrl, paramToRemove);

        //     window.history.pushState({}, '', updatedUrl);

        //     console.log('Updated URL:', updatedUrl);
        // }

        // updateCurrentUrl('param2');


    });
</script>

<?= $this->endSection() ?>