<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Register User <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <h5 class="card-header">Register User</h5>
            <div class="card-body">
                <form>
                    <?= csrf_field() ?>

                    <p id="description">
                        <span class="helper text-secondary">Please fill out the required fields to register user.</span>
                        <span class="error text-danger"></span>
                    </p>

                    <hr class="my-4 mx-n4">
                    <h6>1. User's Name</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="first_name">First Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="first_name" class="form-control" id="first_name" placeholder="Enter first name" value="<?= old('first_name') ?>" autofocus />
                            <small class="text-danger input-error" data-for="first_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="first_name"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="last_name">Last Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="last_name" class="form-control" id="last_name" placeholder="Enter last name" value="<?= old('last_name') ?>" />
                            <small class="text-danger input-error" data-for="last_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="last_name"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="middle_name">Middle Name (Optional)</label>
                        <div class="col-sm-9">
                            <input type="text" name="middle_name" class="form-control" id="middle_name" placeholder="Enter middle name (optional)" value="<?= old('middle_name') ?>" />
                            <small class="text-danger input-error" data-for="middle_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="middle_name"></small>
                        </div>
                    </div>

                    <hr class="my-4 mx-n4">
                    <h6>2. Profile Info</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="username">Username</label>
                        <div class="col-sm-9">
                            <input type="text" name="username" class="form-control" id="username" placeholder="Enter username" value="<?= old('username') ?>" />
                            <small class="text-danger input-error" data-for="username"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="username"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="branch_id">Branch (Optional)</label>
                        <div class="col-sm-9">
                            <select name="branch_id" id="branch_id" class="form-select select2">
                                <option value="">Select a branch</option>
                                <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                    <option value="<?= $branch->id ?>" <?= $branch->id == old('branch_id') ? 'selected' : '' ?>><?= $branch->branch_name ?></option>
                                <?php endforeach ?>
                            </select>
                            <small class="text-danger input-error" data-for="branch_id"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="branch_id">
                                It is recommended to fill out this field if branch is known or exist.
                            </small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="group">Group</label>
                        <div class="col-sm-9">
                            <select name="group" id="group" class="form-select select2">
                                <option value="">Select a group</option>
                                <?php foreach (array_keys(setting('AuthGroups.groups')) as $group) : ?>
                                    <option value="<?= $group ?>" <?= $group == old('group') ? 'selected' : '' ?>><?= ucwords($group) ?></option>
                                <?php endforeach ?>
                            </select>
                            <small class="text-danger input-error" data-for="group"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="group"></small>
                        </div>
                    </div>

                    <hr class="my-4 mx-n4">
                    <h6>3. Login Info</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="email">Email Address</label>
                        <div class="col-sm-9">
                            <input type="email" name="email" class="form-control" id="email" placeholder="Enter email" value="<?= old('email') ?>" />
                            <small class="text-danger input-error" data-for="email"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="email"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="phone_number">Contact Number (Optional)</label>
                        <div class="col-sm-9">
                            <input type="text" name="phone_number" class="form-control" id="phone_number" placeholder="Enter contact number (optional)" value="<?= old('phone_number') ?>" />
                            <small class="text-danger input-error" data-for="phone_number"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="phone_number"></small>
                        </div>
                    </div>

                    <hr class="my-4 mx-n4">
                    <h6>4. Security</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="password">Password</label>
                        <div class="col-sm-9 form-password-toggle">
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control" name="password" placeholder="Enter password" aria-describedby="password" />
                                <span class="input-group-text"><i class="bx bx-hide"></i></span>
                            </div>
                            <small class=" text-danger input-error" data-for="password"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="password"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="password_confirm">Confirm Password</label>
                        <div class="col-sm-9 form-password-toggle">
                            <div class="input-group input-group-merge">
                                <input type="password" id="password_confirm" class="form-control" name="password_confirm" placeholder="Confirm password" aria-describedby="password" />
                                <span class="input-group-text"><i class="bx bx-hide"></i></span>
                            </div>
                            <small class="text-danger input-error" data-for="password_confirm"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="password_confirm"></small>
                        </div>
                    </div>

                    <div class="row justify-content-end" id="actionButtons">
                        <div class="col-sm-9">
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-outline-secondary" data-toggle="cancel" disabled>
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-primary d-flex align-items-center gap-2" disabled>
                                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    Register
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/js/swal2_init.js"></script>
<script src="/assets/js/form_helper.js"></script>
<script type="text/javascript">
    $(document).ready(function() {

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            let data = response.user;
            setCancelButton(data, "<?= user_url() ?>");
            setRequest(data, "<?= user_url("store") ?>", "<?= user_url() ?>");
        });

    });
</script>

<?= $this->endSection() ?>

<?= $this->endSection() ?>