function simpleSwal(action_def) {
  Swal.fire({
    title: action_def.title ?? null,
    html: action_def.text ?? null,
    icon: action_def.icon ?? null,
    showConfirmButton: action_def.confirm.visible ?? true,
    showCancelButton: action_def.cancel.visible ?? false,
    confirmButtonText: action_def.confirm.text ?? "Yes",
    cancelButtonText: action_def.cancel.text ?? "Cancel",
  }).then((result) => {
    if (result.isConfirmed) {
      if (typeof action_def.onConfirm === "function") {
        action_def.onConfirm();
      }
    } else {
      if (typeof action_def.onCancel === "function") {
        action_def.onCancel();
      }
    }
  });
}
