<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTicketTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'            => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'auto_increment'    => true,
            ],
            'event_id'      => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true
            ],
            'ticket_number' => [
                'type'              => 'VARCHAR',
                'constraint'        => '80',
                'null'              => true
            ],
            'branch_id'     => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true
            ],
            'id_number'     => [
                'type'              => 'VARCHAR',
                'constraint'        => 30,
                'null'              => true,
            ],
            'first_name'    => [
                'type'              => 'VARCHAR',
                'constraint'        => 50,
                'null'              => true,
            ],
            'last_name'     => [
                'type'              => 'VARCHAR',
                'constraint'        => 50,
                'null'              => true,
            ],
            'middle_name'   => [
                'type'              => 'VARCHAR',
                'constraint'        => 50,
                'null'              => true,
            ],
            'email'         => [
                'type'              => 'VARCHAR',
                'constraint'        => 255,
                'null'              => false,
            ],
            'phone_number'  => [
                'type'              => 'VARCHAR',
                'constraint'        => 20,
                'null'              => true,
            ],
            'position'      => [
                'type'              => 'VARCHAR',
                'constraint'        => '20',
                'null'              => true,
            ],
            'department'    => [
                'type'              => 'VARCHAR',
                'constraint'        => '20',
                'null'              => true,
            ],
            'year'          => [
                'type'              => 'VARCHAR',
                'constraint'        => '10',
                'null'              => true,
            ],
            'track'         => [
                'type'              => 'VARCHAR',
                'constraint'        => '100',
                'null'              => true,
            ],
            'req_submitted' => [
                'type'              => 'TINYINT',
                'constraint'        => 1,
                'default'           => 0,
            ],
            'date_attend'   => [
                'type'              => 'DATETIME',
                'null'              => true,
            ],
            'date_leave'    => [
                'type'              => 'DATETIME',
                'null'              => true,
            ],
            'created_by'    => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
            ],
            'created_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
            'updated_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
            'deleted_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('event_id', 'events', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('branch_id', 'branches', 'id', 'CASCADE', 'SET NULL');
        $this->forge->addForeignKey('created_by', 'users', 'id', 'CASCADE', 'SET NULL');
        $this->forge->addUniqueKey(['event_id', 'branch_id', 'id_number']);
        $this->forge->addUniqueKey(['event_id', 'email']);
        $this->forge->createTable('tickets');
    }

    public function down()
    {
        $this->forge->dropTable('tickets');
    }
}
