<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateLogTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'            => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'auto_increment'    => true,
            ],
            'timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP',
            'action'        => [
                'type'              => 'VARCHAR',
                'constraint'        => '50',
                'null'              => true,
            ],
            'entity_id'     => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
            ],
            'module'        => [
                'type'              => 'VARCHAR',
                'constraint'        => '20',
                'null'              => true,
            ],
            'performed_by'  => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
            ]
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('performed_by', 'users', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('logs');
    }

    public function down()
    {
        $this->forge->dropTable('logs');
    }
}
