<?php

if (!function_exists('clean_input_data')) {
    /**
     * Clean input data by setting fields with only spaces to null.
     */
    function clean_input_data(array $data, ?array $capitalizeFields = null): array
    {
        foreach ($data as $key => $value) {

            $stringValue = (string) $value;
            $trimmedValue = trim($stringValue);

            if (empty($trimmedValue)) {
                $data[$key] = null;
            } else {

                if (isset($capitalizeFields) && in_array($key, $capitalizeFields)) {
                    $data[$key] = ucfirst($trimmedValue);
                } else {
                    $data[$key] = $trimmedValue;
                }
            }
        }

        // foreach ($data as $key => $value) {
        //     if (is_string($value) && empty(trim($value))) {
        //         $data[$key] = null;
        //     }

        //     if (isset($capitalizeFields) && in_array($key, $capitalizeFields)) {
        //         $data[$key] = ucfirst($value);
        //     }
        // }
        return $data;
    }
}
