<?php

if (!function_exists('log_descriptor')) {
    /**
     * Makes a description for a data only log.
     * 
     * @param array|object $data
     */
    function log_descriptor($data): string
    {
        if (is_object($data)) {
            $data = (array) $data;
        }

        $phrase = [];

        switch ($data['action']) {
            case 'insert':
                $phrase[] = "Creates";
                break;

            case 'update':
                $phrase[] = "Updates";
                break;

            case 'delete':
                $phrase[] = "Deletes";
                break;

            default:
                $phrase[] = ucfirst($data['action']);
                break;
        }

        switch ($data['module']) {
            case 'branches':
                $phrase[] = "a branch";
                $branch = model('BranchModel')->find($data['entity_id']);
                if ($branch && is_object($branch)) {
                    $phrase[] = "with a code of {$branch->branch_code}";
                }
                break;

            case 'events':
                $phrase[] = "an event";
                $event = model('EventModel')->find($data['entity_id']);
                if ($event && is_object($event)) {
                    $phrase[] = "with a code of {$event->event_code}";
                }
                break;

            case 'tickets':
                $phrase[] = "a ticket";
                $ticket = model('TicketModel')->find($data['entity_id']);
                if ($ticket && is_object($ticket)) {
                    $phrase[] = "with a ticket number of {$ticket->ticket_number}";
                }
                break;

            case 'users':
                $phrase[] = "a user";
                $user = model('UserModel')->find($data['entity_id']);
                if ($user && is_object($user)) {
                    if ($user->id === user_id() && $data['action'] === "update") {
                        $phrase = ["Updates own account"];
                    } else {
                        $phrase[] = "with a username of @{$user->username}";
                    }
                }
                break;

            default:
                $phrase[] = "an unknown entity with an id of {$data['id']}";
                break;
        }

        $description = implode(" ", $phrase) . ".";

        return $description;
    }
}
