<?php

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Config\Services;

if (!function_exists('encrypt_data')) {
    function encrypt_data($data)
    {
        $encrypter = Services::encrypter();
        return base64url_encode($encrypter->encrypt($data));
    }
}

if (!function_exists('decrypt_data')) {
    function decrypt_data($data)
    {
        $encrypter = Services::encrypter();
        return $encrypter->decrypt(base64url_decode($data));
    }
}

if (!function_exists('base64url_encode')) {
    function base64url_encode($data)
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }
}

if (!function_exists('base64url_decode')) {
    function base64url_decode($data)
    {
        return base64_decode(strtr($data, '-_', '+/'));
    }
}

if (!function_exists('generate_qr_code_data')) {
    function generate_qr_code_data($data, $size = 300, $use_api = false): string
    {
        $encryptedData = encrypt_data($data);

        if ($use_api) {
            return "https://api.qrserver.com/v1/create-qr-code/?size={$size}x{$size}&data={$encryptedData}";
        } else {

            // Embedding images with Data URI in Emails is still not optimal

            $result = Builder::create()
                ->writer(new PngWriter())
                ->writerOptions([])
                ->data($encryptedData)
                ->encoding(new Encoding('UTF-8'))
                ->errorCorrectionLevel(new ErrorCorrectionLevel\ErrorCorrectionLevelLow)
                ->size(300)
                ->build();

            return 'data:image/png;base64,' . base64_encode($result->getString());
        }
    }
}
