<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset='UTF-8' />
    <meta http-equiv='X-UA-Compatible' content='IE=edge' />
    <meta name='viewport' content='width=device-width, initial-scale=1.0' />
    <link rel='preconnect' href='https://fonts.googleapis.com' />
    <link rel='preconnect' href='https://fonts.gstatic.com' crossorigin />
    <link rel='stylesheet' href='https://fonts.googleapis.com/css2?family=Poppins&display=swap' />
    <style>
        .container {
            font-family: 'Poppins', sans-serif;
            font-weight: 400;
            font-style: normal;
            background-color: white;
            border: 1px solid lightgray;
            border-radius: 10px;
            margin: auto;
            max-width: 500px;
            text-align: center;
        }
        .subject {
            background-color: #004ea8;
            color: white;
        }
        .content {
            padding: 0 25px;
        }
        .logo {
            width: 75px;
            padding-top: 25px;
        }
    </style>
</head>
<body>
    <p style="display: none;">
        Hi, <?= $name ?>!
        Your ticket to <?= $event?> is now registered.
        Here's your QR code for your ticket that you can present to our staff
        on the actual day of the event for your smooth entry.
    </p>
    <div class="container">
        <img
            class="logo"
            alt="Arellano University"
            src="https://www.arellano.edu.ph/sites/default/files/inline-images/new-au-logo.png"
        />
        <h2 class="subject">Here's Your QR Code</h2>
        <div class="content">
            <img alt="QR Code" src="<?= $qrCodeUrl ?>" />
            <h2>Hi, <?= $name ?>!</h2>
            <p>
                Your ticket to <strong><?= $event?></strong> is now registered!
                Kindly present this QR code to our staff on the actual day of the event for your smooth entry.
            </p>
            <p>
                Please note that you still
                <strong>need to bring your actual ticket and valid ID</strong>
                for confirmation.
            </p>
        </div>
        <hr>
        <div class="content">
            <h3 style="color: #da291c;">Thank you!</h3>
        </div>
    </div>
</body>
</html>