<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Event List <?= $this->endSection() ?>

<?= $this->section('entity') ?> Event <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link href="/assets/vendor/DataTables/datatables.css" rel="stylesheet">

<?= $this->endSection() ?>

<?= $this->section('navbar-items') ?>

<!-- <li class="nav-item lh-1 me-2 navbar-actions" id="selectionActions">
    <div class="btn-group" role="group" aria-label="Toolbar">
        <button type="button" class="btn btn-outline-secondary px-2" data-action="removeSelection" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remove Selection" disabled>
            <i class="tf-icons bx bx-x"></i>
        </button>
        <?php if (auth()->loggedIn() && auth()->user()->can('logs.delete')) : ?>
            <button type="button" class="btn btn-outline-secondary px-2" data-action="delete" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remove Events" disabled>
                <i class="tf-icons bx bx-trash"></i>
            </button>
        <?php endif ?>
    </div>
</li> -->

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header">
        <!-- <h5>Log List</h5> -->

        <?= $this->include('partials/elements/common/alert') ?>

        <div class="row align-items-center gy-3">
            <div class="col">
                <form id="recordfilter" method="post">
                    <div class="d-flex align-items-center gap-2 row-gap-2 flex-wrap">
                        <div class="mb-2">
                            <i class='bx bx-filter'></i>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="module" id="module">
                                <option value="">All Module</option>
                                <option value="branches">Branches</option>
                                <option value="events">Events</option>
                                <!-- <option value="schedules">Schedules</option> -->
                                <option value="tickets">Tickets</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-auto">
                <div class="">
                    <button class="btn btn-danger" data-action="clear" tabindex="0">
                        <span><i class="bx bx-trash me-sm-1"></i></span>
                        <span class="d-none d-sm-inline-block">Clear Logs</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div id="table_container" class="">
        <table id="log_table" class="table table-striped nowrap" style="width: 100%;">
            <thead>
                <tr>
                    <th></th>
                    <th class="col_id">#</th>
                    <th class="col_date">Date</th>
                    <th class="col_desc">Description</th>
                    <th class="col_mod">Module</th>
                    <th class="col_perf">Performed By</th>
                    <th></th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/vendor/DataTables/datatables.js"></script>
<script src="/assets/js/dt_swal2_init.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var dataTable = init_dt_serverside({
            table: "#log_table",
            debug: <?= (ENVIRONMENT !== 'production') ? 'true' : 'false' ?>,
            url: "<?= log_url('fetchAll') ?>",
            data: function(d) {
                d.new_search = $('#searchbar').val();
                d.filter = $('#recordfilter').serialize();

                <?= (ENVIRONMENT !== 'production') ? 'console.log("Parameters:", d);' : '' ?>
            },
            columns: [{
                    data: null,
                    defaultContent: '',
                    orderable: false,
                    className: 'exclude-select pe-0',
                }, {
                    data: 'id',
                    name: 'id',
                },
                {
                    data: 'timestamp',
                    name: 'timestamp',
                    responsivePriority: 1,
                },
                {
                    data: 'description',
                    className: "text-wrap",
                    orderable: false,
                },
                {
                    data: 'module',
                    orderable: false,
                },
                {
                    data: 'performed_by',
                    orderable: false,
                    responsivePriority: 1,
                },
                {
                    data: null,
                    defaultContent: '',
                    orderable: false,
                    className: 'exclude-select pe-0',
                }
            ],
            columnDefs: [{
                targets: '_all',
                className: 'dt-head-left dt-body-left align-middle',
            }],
            rows: 50,
            sort: {
                name: 'id',
                dir: 'desc',
            },
            select: false,
            createdRow: false,
            filtering: true
        });

        //var selectedData = getSelectedRows(dataTable);

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            const data = response.log;
            setActions(dataTable, data, "<?= log_url() ?>");
        });
    });
</script>

<?= $this->endSection() ?>