<?php $user = auth()->user() ?>

<div class="d-none" id="view_<?= esc($ticket->id) ?>">
    <div class="p-3 border-bottom">
        <div class="d-flex gap-2">
            <div class="">
                <img src="<?= generate_qr_code_data($ticket->ticket_number, 125, true) ?>" alt="QR Code">
            </div>
            <div class="flex-fill">
                <div class="mb-2">
                    <small>Event Code</small>
                    <div class="fw-bold"><?= esc($ticket->event_code) ?></div>
                </div>
                <div class="mb-2">
                    <small>Branch</small>
                    <div class="fw-bold"><?= esc($ticket->branch_name) ?></div>
                </div>
            </div>
        </div>
    </div>
    <div class="flex-grow-1 overflow-auto p-3">
        <div class="mb-2">
            <small>Ticket Number</small>
            <div class="fw-bold"><?= esc($ticket->ticket_number) ?></div>
        </div>
        <div class="mb-2">
            <small>Name</small>
            <div>
                <?= view("partials/elements/common/table_user_name", [
                    "first_name"  => $ticket->first_name,
                    "middle_name" => $ticket->middle_name,
                    "last_name"   => $ticket->last_name,
                    "email"       => null,
                    "username"    => null,
                ]) ?>
            </div>
        </div>
        <div class="mb-2">
            <small>Email</small>
            <div class="fw-bold"><?= esc($ticket->email) ?></div>
        </div>
        <div class="mb-2">
            <small>LRN/Student/ID Number</small>
            <div class="fw-bold"><?= esc($ticket->id_number) ?></div>
        </div>
        <?= view("partials/elements/tickets/role", [
            "department"  => $ticket->department,
            "position"    => $ticket->position,
            "year"        => $ticket->year,
            "track"       => $ticket->track,
            "offcanvas"   => true
        ]); ?>
        <div class="mb-2">
            <small>Requirements Status</small>
            <div class="fw-bold">
                <?= view("partials/elements/tickets/requirement_status", [
                    "status" => $ticket->req_submitted,
                ]) ?>
            </div>
        </div>
        <div class="mb-2">
            <small>Attended</small>
            <div class="fw-bold"><?= $ticket->date_attend ? date("Y-M-d | h:i A", strtotime($ticket->date_attend)) : 'Not Yet' ?></div>
        </div>
        <div class="mb-2">
            <small>Early Leaved</small>
            <div class="fw-bold"><?= $ticket->date_leave ? date("Y-M-d | h:i A", strtotime($ticket->date_leave)) : 'Did Not Leaved Early' ?></div>
        </div>
        <div class="mb-2">
            <small>Encoder</small>
            <div>
                <?= view("partials/elements/common/table_user_name", [
                    "first_name"  => $ticket->encoder_first_name,
                    "middle_name" => $ticket->encoder_middle_name,
                    "last_name"   => $ticket->encoder_last_name,
                    "email"       => null,
                    "username"    => $ticket->encoder_username,
                ]) ?>
            </div>
        </div>
        <div class="mb-2">
            <small>Date Encoded</small>
            <div class="fw-bold">
                <?= $ticket->created_at ? date("Y-M-d | h:i A", strtotime($ticket->created_at)) : '' ?>
            </div>
        </div>
    </div>
    <div class="p-3 border-top">
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="offcanvas">Close</button>
            <?php if (isset($permissions['edit']) && $user && $user->can($permissions['edit'])) : ?>
                <a href="<?= ticket_url("edit/{$ticket->id}") ?>" class="btn btn-outline-primary" title="Edit">
                    <span class="tf-icons bx bx-edit-alt me-1"></span>
                    Edit
                </a>
            <?php endif ?>
            <!-- <button type="button" class="btn btn-outline-secondary" data-action="resendqr" data-id="<?= $ticket->id ?>">Resend QR</button> -->
            <div class="d-flex gap-2 ms-auto">

                <?php if (isset($permissions['edit']) && $user && $user->can($permissions['edit'])) : ?>
                    <!-- <a href="<?= ticket_url("edit/{$ticket->id}") ?>" class="btn btn-outline-primary" title="Edit">
                        <span class="tf-icons bx bx-edit-alt me-1"></span>
                        Edit
                    </a> -->
                <?php endif ?>

                <!--
                    <button type="button" class="btn btn-icon btn-outline-danger toggle-delete" title="Delete" data-toggle="delete" data-ticket-id="<?= $ticket->id ?>">
                        <span class="tf-icons bx bx-trash"></span>
                    </button>
                    -->

            </div>
        </div>
    </div>
</div>