<?php

/** @var \Config\RiceData $config */
$config       = config('RiceData');
$menu         = $config->getMenuLinks();
$current_uri  = current_url();
$user         = auth()->user();

?>

<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme pb-5">
    <div class="app-brand demo">
        <a href="<?= base_url() ?>" class="app-brand-link">
            <span class="app-brand-logo demo">
                <img src="/assets/img/au_logo.png" alt="AU Logo" width="35" />
            </span>
            <span class="app-brand-text demo menu-text fw-bolder ms-2">auticket</span>
        </a>

        <a role="button" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
            <i class="bx bx-chevron-left bx-sm align-middle"></i>
        </a>
    </div>

    <div class="menu-inner-shadow"></div>

    <ul class="menu-inner py-1">

        <?php if (isset($menu) && is_array($menu)) :  ?>

            <?php foreach ($menu as $section => $items) : ?>

                <?php if (!empty($items) && is_array($items)) : ?>

                    <?php $isFirstItem = true ?>

                    <?php foreach ($items as $title => $details) : ?>

                        <?php
                        $subItemCount   = 0;
                        $permission     = $details['permissions'][$subItemCount] ?? null;
                        if ($permission && !auth()->user()->can($permission)) {
                            continue;
                        }
                        ?>

                        <?php if ($isFirstItem && !empty($section) && $section !== "main") : ?>

                            <li class="menu-header small text-uppercase">
                                <span class="menu-header-text"><?= $section ?></span>
                            </li>

                            <?php $isFirstItem = false ?>
                        <?php endif ?>

                        <?php $in_subroutes = in_array($current_uri, $details['subroutes']) ?>
                        <?php $menu_active  = $current_uri == $details['route'] ?>
                        <?php $in_hidden    = array_filter($details['hidden'], fn ($hidden) => strpos($current_uri, $hidden) !== false) ?>

                        <li class="menu-item <?= $in_subroutes || $menu_active || $in_hidden ? 'active open' : '' ?>">

                            <?php if (!empty($details['subroutes'])) : ?>

                                <a role="button" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons bx <?= $details['icon'] ?>"></i>
                                    <div data-i18n="<?= $title ?>"><?= $title ?></div>
                                </a>

                                <ul class="menu-sub">

                                    <?php foreach ($details['subroutes'] as $subtitle => $sublink) : ?>

                                        <?php if ($permission = $details['permissions'][$subItemCount] ?? null) : ?>

                                            <?php if ($user && $user->can($permission)) : ?>

                                                <li class="menu-item <?= $current_uri == $sublink ? 'active' : '' ?>">
                                                    <a href="<?= $sublink ?>" class="menu-link">
                                                        <div data-i18n="<?= $subtitle ?>"><?= $subtitle ?></div>
                                                    </a>
                                                </li>

                                            <?php endif ?>

                                            <?php $subItemCount++ ?>

                                        <?php endif ?>

                                    <?php endforeach ?>

                                </ul>

                            <?php else : ?>

                                <a href="<?= $details['route'] ?>" class="menu-link">
                                    <i class="menu-icon tf-icons bx <?= $details['icon'] ?>"></i>
                                    <div data-i18n="<?= $title ?>"><?= $title ?></div>
                                </a>

                            <?php endif ?>

                        </li>

                    <?php endforeach; ?>
                <?php endif ?>
            <?php endforeach ?>
        <?php endif ?>

    </ul>
</aside>