<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Register Ticket <?= $this->endSection() ?>

<?= $this->section('content') ?>

<?php if (session()->getFlashdata('error')['main'] ?? false): ?>

    <div class="alert alert-danger my-3" role="alert">
        <?= session()->getFlashdata('error')['main'] ?>
    </div>

<?php else: ?>

    <?php foreach (['event_id', 'ticket_number', 'profile_id', 'created_by'] as $key): ?>

        <?php if (session()->getFlashdata('error')[$key] ?? false): ?>

        <div class="alert alert-danger my-3" role="alert">
            Something went wrong on registering ticket on our end.
            Please try again later or try to contact admin.
        </div>

        <?php break; ?>

        <?php endif; ?>

    <?php endforeach ?>

<?php endif ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <h5 class="card-header">Register Ticket</h5>
            <div class="card-body">
                <form action="<?= current_url() ?>" method="post">
                    <?= csrf_field() ?>
                    <div>
                        <p>Please fill out the  fields to register ticket.</p>
                        
                        <hr class="my-4 mx-n4">
                        <h6>1. Owner's Name</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="firstName">First Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="firstName" class="form-control" id="firstName" placeholder="Enter first name" value="<?= old('firstName') ?>" autofocus />
                                <small class="text-danger"><?= session()->getFlashdata('error')['first_name'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="lastName">Last Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="lastName" class="form-control" id="lastName" placeholder="Enter last name" value="<?= old('lastName') ?>"  />
                                <small class="text-danger"><?= session()->getFlashdata('error')['last_name'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="middleName">Middle Name (Optional)</label>
                            <div class="col-sm-9">
                                <input type="text" name="middleName" class="form-control" id="middleName" placeholder="Enter middle name (optional)" value="<?= old('middleName') ?>"  />
                                <small class="text-danger"><?= session()->getFlashdata('error')['middle_name'] ?? '' ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>2. Other Details</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="validID">Valid ID Number</label>
                            <div class="col-sm-9">
                                <input type="text" name="validID" class="form-control" id="validID" placeholder="Enter valid ID number" value="<?= old('validID') ?>"  />
                                <?php if (!empty(session()->getFlashdata('error')['id_number'])): ?>
                                    <small class="text-danger"><?= session()->getFlashdata('error')['id_number'] ?></small>
                                <?php else: ?>
                                    <small class="text-secondary">Can be an LRN, student number, or any valid ID number</small>
                                <?php endif ?>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="branch">Branch</label>
                            <div class="col-sm-9">
                                <select name="branch" id="branch" class="form-select select2" >
                                    <option value="">Select a branch</option>
                                    <?php foreach ($branches as $branch): ?>
                                        <option value="<?= $branch['id'] ?>" <?= $branch['id'] == old('branch') ? 'selected' : '' ?>><?= $branch['branch_name'] ?></option>
                                    <?php endforeach ?>
                                </select>
                                <small class="text-danger"><?= session()->getFlashdata('error')['branch'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="position">Position</label>
                            <div class="col-sm-9">
                                <select name="position" id="position" class="form-select select2" >
                                    <option value="">Select a position</option>
                                </select>
                                <small class="text-danger"><?= session()->getFlashdata('error')['position'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3 d-none" id="department_container">
                            <label class="col-sm-3 col-form-label" for="department">Department</label>
                            <div class="col-sm-9">
                                <select name="department" id="department" class="form-select select2" disabled >
                                    <option value="">Select a department</option>
                                </select>
                                <small class="text-danger"><?= session()->getFlashdata('error')['department'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3 d-none" id="year_container">
                            <label class="col-sm-3 col-form-label" for="year">Grade/Year Level</label>
                            <div class="col-sm-9">
                                <select name="year" id="year" class="form-select select2" disabled >
                                    <option value="">Select a level</option>
                                </select>
                                <small class="text-danger"><?= session()->getFlashdata('error')['year'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3 d-none" id="track_container">
                            <label class="col-sm-3 col-form-label" for="track">Strand/Course</label>
                            <div class="col-sm-9">
                                <select name="track" id="track" class="form-select select2" disabled >
                                    <option value="">Select a strand/course</option>
                                    <option value="BSCS">Bachelor of Science in Computer Science</option>
                                    <option value="ICT">Information and Communications Technology</option>
                                </select>
                                <small class="text-danger"><?= session()->getFlashdata('error')['track'] ?? '' ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>3. Contact Info</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="email">Email Address</label>
                            <div class="col-sm-9">
                                <input type="email" name="email" class="form-control" id="email" placeholder="Enter email" value="<?= old('email') ?>"  />
                                <?php if (!empty(session()->getFlashdata('error')['email'])): ?>
                                    <small class="text-danger"><?= session()->getFlashdata('error')['email'] ?></small>
                                <?php else: ?>
                                    <small class="text-secondary">Must be valid as ticket QR code will be sent to this email</small>
                                <?php endif ?>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="phoneNumber">Contact Number (Optional)</label>
                            <div class="col-sm-9">
                                <input type="text" name="phoneNumber" class="form-control" id="phoneNumber" placeholder="Enter contact number (optional)" value="<?= old('phoneNumber') ?>"  />
                                <small class="text-danger"><?= session()->getFlashdata('error')['phone_number'] ?? '' ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>4. Requirements Status</h6>

                        <div class="mb-4">
                            <div class="form-check">
                                <input type="checkbox" name="submitted" class="form-check-input" id="submitted" value="1" <?= old('submitted') ? 'checked' : '' ?> />
                                <label class="form-check-label" for="submitted">I hereby confirm that the owner of this ticket has already submitted his or her requirements. (Please leave unchecked if not yet).</label>
                            </div>
                        </div>
                        <div class="mb-3" id="action_buttons">
                            <div class="d-flex align-items-center gap-2">
                                <button
                                    type="button"
                                    class="btn btn-outline-secondary"
                                    data-bs-toggle="modal"
                                    data-bs-target="#cancel_confirmation"
                                    disabled
                                >
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-primary d-flex align-items-center gap-2" disabled>
                                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    Register
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="cancel_confirmation" tabindex="-1" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cancel Registration?</h5>
                <button
                    type="button"
                    class="btn-close"
                    data-bs-dismiss="modal"
                    aria-label="Close"
                ></button>
            </div>
            <div class="modal-body">
                <p>
                    Are you sure you want to cancel the registration for this ticket?
                    All unsaved data will be discarded.
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    No
                </button>
                <button onclick="window.location.href='<?= base_url('ticket') ?>';" class="btn btn-danger">
                    Yes
                </button>
            </div>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<script>

$(document).ready(function(){

    setTimeout(() => {
        $('#action_buttons').find('button').prop('disabled', false);
    }, 1000);

    $.when(
        $.getJSON('<?= base_url('assets/json/attendees/positions.json') ?>'),
        $.getJSON('<?= base_url('assets/json/attendees/departments.json') ?>')
    ).done(function(positions, departments) {
        let positionsData = positions[0];
        let departmentsData = departments[0];

        $.each(positionsData, function(position, departments) {
            $('#position')
                .append(
                    $('<option></option>')
                        .attr('value', position)
                        .text(position.charAt(0).toUpperCase() + position.slice(1))
                );
        });

        var selectedPosition = null;

        $('#position').change(function() {
            selectedPosition = $(this).val();
            $('#department').empty().append('<option value="">Select a Department</option>');
            $('#year').empty().append('<option value="">Select a Level</option>');
            $('#track').empty().append('<option value="">Select a Strand/Course</option>');

            if (selectedPosition
                && positionsData[selectedPosition]
                && $.isEmptyObject(positionsData[selectedPosition]) == false) {

                disableField('#department_container', false);
                disableField('#year_container');
                disableField('#track_container');

                $.each(positionsData[selectedPosition], function(index, department) {
                    if (departmentsData[department]){
                        $('#department').append(
                            $('<option></option>').attr('value', department).text(departmentsData[department].label)
                        );
                    }
                });
            }
            else {
                disableField('#department_container');
                disableField('#year_container');
                disableField('#track_container');
            }
        });

        $('#department').change(function() {
            let selectedDepartment = $(this).val();
            $('#year').empty().append('<option value="">Select a Level</option>');
            $('#track').empty().append('<option value="">Select a Strand/Course</option>');

            if (selectedDepartment
                && departmentsData[selectedDepartment]
                && $.inArray(selectedPosition, departmentsData[selectedDepartment].for) + 1) {

                let years = departmentsData[selectedDepartment].year;

                if (years){

                    disableField('#year_container', false);
                            
                    $.each(years, function(index, year) {
                        $('#year').append(
                            $('<option></option>').attr('value', year).text(year)
                        )
                        .find('option[value="<?= old('year') ?>"]').prop('selected', true);
                    });
                }
                else {
                    disableField('#year_container');
                }

                let trackFile = departmentsData[selectedDepartment].track;

                if (trackFile) {

                    disableField('#track_container', false);

                    $.getJSON('<?= base_url('assets/json/attendees/') ?>' + trackFile, function(trackData) {
                        $.each(trackData, function(track, description) {
                            $('#track').append(
                                $('<option></option>').attr('value', track).text(track + ' - ' + description)
                            )
                            .find('option[value="<?= old('track') ?>"]').prop('selected', true);
                        });
                    });
                }
                else {
                    disableField('#track_container');
                }
            }
            else {
                disableField('#year_container');
                disableField('#track_container');
            }
        });

        $('#position').val('<?= old('position') ?>').trigger('change');
        $('#department').val('<?= old('department') ?>').trigger('change');
    });

    $('form').on('submit', function(event) {

        if ($(this).data('submitted') === true) {
            event.preventDefault();
        }
        else {
            $(this).data('submitted', true);
        
            $('#action_buttons').find('button').prop('disabled', true);
            
            $('#action_buttons').find('button[type="submit"] #submit_spinner').removeClass('d-none');
        }
    });

    function disableField(container_id, disable = true) {

        const $fieldContainer = $(container_id);
        
        $fieldContainer
            .find('input, select, textarea')
            .prop('disabled', disable);

        if (disable) {
            $fieldContainer.addClass('d-none');
        }
        else {
            $fieldContainer.removeClass('d-none');
        }
    }
});

</script>

<?= $this->endSection() ?>

<?= $this->endSection() ?>