<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> User Accounts <?= $this->endSection() ?>

<?= $this->section('entity') ?> User <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link href="/assets/vendor/DataTables/datatables.css" rel="stylesheet">

<?= $this->endSection() ?>

<?= $this->section('navbar-items') ?>

<li class="nav-item lh-1 me-2 navbar-actions" id="selectionActions">
    <div class="d-none d-sm-block">
        <div class="btn-group" role="group" aria-label="Toolbar">
            <button type="button" class="btn btn-outline-secondary px-2" data-action="removeSelection" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remove Selection" disabled>
                <i class="tf-icons bx bx-x"></i>
            </button>
            <button type="button" class="btn btn-outline-secondary px-2" data-action="unban" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Reactivate Users" disabled>
                <i class="tf-icons bx bx-chevrons-up"></i>
            </button>
            <button type="button" class="btn btn-outline-secondary px-2" data-action="ban" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Suspend Users" disabled>
                <i class="tf-icons bx bx-chevrons-down"></i>
            </button>
            <?php if (auth()->loggedIn() && auth()->user()->can('users.delete')) : ?>
                <button type="button" class="btn btn-outline-secondary px-2" data-action="delete" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remove Users" disabled>
                    <i class="tf-icons bx bx-trash"></i>
                </button>
            <?php endif ?>
        </div>
    </div>
    <div class="d-block d-sm-none nav-item navbar-dropdown dropdown">
        <button type="button" class="btn btn-secondary btn-icon rounded-pill dropdown-toggle hide-arrow" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bx bx-dots-vertical-rounded"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end">
            <li>
                <button class="dropdown-item" data-action="removeSelection" disabled>
                    <i class="bx bx-x me-1"></i>
                    Remove Selection
                </button>
            </li>
            <li>
                <button class="dropdown-item" data-action="unban" disabled>
                    <i class="bx bx-chevrons-up me-1"></i>
                    Reactivate Users
                </button>
            </li>
            <li>
                <button class="dropdown-item" data-action="ban" disabled>
                    <i class="bx bx-chevrons-down me-1"></i>
                    Suspend Users
                </button>
            </li>
            <?php if (auth()->loggedIn() && auth()->user()->can('users.delete')) : ?>
                <li>
                    <button class="dropdown-item" data-action="delete" disabled>
                        <i class="bx bx-trash me-1"></i>
                        Remove Users
                    </button>
                </li>
            <?php endif ?>
        </ul>
    </div>
</li>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header">
        <h5>User Management</h5>

        <?= $this->include('partials/elements/common/alert') ?>

        <div class="row align-items-center gy-3">
            <div class="col">
                <form id="recordfilter" method="post">
                    <div class="d-flex align-items-center gap-2 row-gap-2 flex-wrap">
                        <div class="mb-2">
                            <i class='bx bx-filter'></i>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="branch" id="branch">
                                <option value="">All Branch</option>
                                <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                    <option value="<?= $branch->id ?>"><?= $branch->branch_name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="group" id="group">
                                <option value="">All Group</option>
                                <?php foreach (array_keys(setting('AuthGroups.groups')) as $group) : ?>
                                    <option value="<?= $group ?>"><?= ucwords($group) ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="active" id="active">
                                <option value="">All Status</option>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-auto">
                <div class="">
                    <a href="<?= user_url('create') ?>" class="btn btn-primary" tabindex="0">
                        <span><i class="bx bx-plus me-sm-1"></i></span>
                        <span class="d-sm-inline-block">Add New User</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div id="table_container" class="">
        <table id="users_table" class="table table-striped nowrap" style="width: 100%;">
            <thead>
                <tr>
                    <th></th>
                    <th class="col_id">#</th>
                    <th class="col_name">Name</th>
                    <th class="col_branch">Branch</th>
                    <th class="col_group">Group</th>
                    <th class="col_active">Status</th>
                    <th class="col_date_created">Last Accessed</th>
                    <th class="col_action"></th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/vendor/DataTables/datatables.js"></script>
<script src="/assets/js/dt_swal2_init.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var dataTable = init_dt_serverside({
            table: "#users_table",
            debug: <?= (ENVIRONMENT !== 'production') ? 'true' : 'false' ?>,
            stateSave: true,
            url: "<?= user_url('fetchAll') ?>",
            data: function(d) {
                d.new_search = $('#searchbar').val();
                d.filter = $('#recordfilter').serialize();

                <?= (ENVIRONMENT !== 'production') ? 'console.log("Parameters:", d);' : '' ?>
            },
            columns: [{
                    data: null,
                    defaultContent: '',
                    orderable: false,
                    className: 'exclude-select pe-0',
                    responsivePriority: 1,
                },
                {
                    data: 'id',
                    name: 'id',
                },
                {
                    data: 'name',
                    name: 'users.first_name',
                    responsivePriority: 1,
                },
                {
                    data: 'branch_name',
                    orderable: false,
                },
                {
                    data: 'group',
                    orderable: false,
                },
                {
                    data: 'status',
                    orderable: false,
                },
                {
                    data: 'last_active',
                    name: 'last_active',
                },
                {
                    data: 'action',
                    responsivePriority: 2,
                    orderable: false,
                    className: 'exclude-select',
                }
            ],
            columnDefs: [{
                targets: '_all',
                className: 'dt-head-left dt-body-left align-middle pointer',
            }],
            rows: 50,
            sort: {
                name: 'id',
                dir: 'desc',
            },
            filtering: true
        });

        //var selectedData = getSelectedRows(dataTable);

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            const data = response.user;
            setActions(dataTable, data, "<?= user_url() ?>");
        });
    });
</script>

<?= $this->endSection() ?>