<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Register User <?= $this->endSection() ?>

<?= $this->section('content') ?>

<?php if (!empty(get_nested_flashdata('errors.main'))) : ?>

    <div class="alert alert-danger my-3" role="alert">
        <?= get_nested_flashdata('errors.main') ?>
    </div>

<?php else : ?>

    <?php foreach (['event_id', 'ticket_number', 'profile_id', 'created_by'] as $key) : ?>

        <?php if (get_nested_flashdata("error.{$key}")) : ?>

            <div class="alert alert-danger my-3" role="alert">
                Something went wrong on registering user on our end.
                Please try again later or try to contact admin.
            </div>

            <?php break; ?>

        <?php endif; ?>

    <?php endforeach ?>

<?php endif ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <h5 class="card-header">Register User</h5>
            <div class="card-body">
                <form action="<?= current_url() ?>" method="post">
                    <?= csrf_field() ?>
                    <div>
                        <p>Please fill out the fields to register user.</p>

                        <hr class="my-4 mx-n4">
                        <h6>1. User's Name</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="first_name">First Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="first_name" class="form-control" id="first_name" placeholder="Enter first name" value="<?= old('first_name') ?>" autofocus />
                                <small class="text-danger"><?= get_nested_flashdata('errors.first_name') ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="last_name">Last Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="last_name" class="form-control" id="last_name" placeholder="Enter last name" value="<?= old('last_name') ?>" />
                                <small class="text-danger"><?= get_nested_flashdata('errors.last_name') ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="middle_name">Middle Name (Optional)</label>
                            <div class="col-sm-9">
                                <input type="text" name="middle_name" class="form-control" id="middle_name" placeholder="Enter middle name (optional)" value="<?= old('middle_name') ?>" />
                                <small class="text-danger"><?= get_nested_flashdata('errors.middle_name') ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>2. Profile Info</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="username">Username</label>
                            <div class="col-sm-9">
                                <input type="text" name="username" class="form-control" id="username" placeholder="Enter username" value="<?= old('username') ?>" />
                                <small class="text-danger"><?= get_nested_flashdata('errors.username') ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="branch">Branch</label>
                            <div class="col-sm-9">
                                <select name="branch_id" id="branch_id" class="form-select select2">
                                    <option value="">Select a branch</option>
                                    <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                        <option value="<?= $branch['id'] ?>" <?= $branch['id'] == old('branch_id') ? 'selected' : '' ?>><?= $branch['branch_name'] ?></option>
                                    <?php endforeach ?>
                                </select>
                                <small class="text-danger"><?= get_nested_flashdata('errors.branch_id') ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="group">Group</label>
                            <div class="col-sm-9">
                                <select name="group" id="group" class="form-select select2">
                                    <option value="">Select a group</option>
                                    <?php foreach (array_keys(setting('AuthGroups.groups')) as $group) : ?>
                                        <option value="<?= $group ?>" <?= $group == old('group') ? 'selected' : '' ?>><?= ucwords($group) ?></option>
                                    <?php endforeach ?>
                                </select>
                                <small class="text-danger"><?= get_nested_flashdata('errors.group') ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>3. Contact Info</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="email">Email Address</label>
                            <div class="col-sm-9">
                                <input type="email" name="email" class="form-control" id="email" placeholder="Enter email" value="<?= old('email') ?>" />
                                <small class="text-danger"><?= get_nested_flashdata('errors.email') ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="phoneNumber">Contact Number (Optional)</label>
                            <div class="col-sm-9">
                                <input type="text" name="phoneNumber" class="form-control" id="phoneNumber" placeholder="Enter contact number (optional)" value="<?= old('phoneNumber') ?>" />
                                <small class="text-danger"><?= get_nested_flashdata('errors.phone_number') ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>4. Security</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="email">Password</label>
                            <div class="col-sm-9">
                                <input type="password" name="password" class="form-control" id="password" placeholder="Enter password" />
                                <small class=" text-danger"><?= get_nested_flashdata('errors.password') ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="email">Confirm Password</label>
                            <div class="col-sm-9">
                                <input type="password" name="password_confirm" class="form-control" id="password_confirm" placeholder="Confirm Password" />
                                <small class="text-danger"><?= get_nested_flashdata('errors.password_confirm') ?></small>
                            </div>
                        </div>

                        <div class="mb-3" id="action_buttons">
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#cancel_confirmation" disabled>
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-primary d-flex align-items-center gap-2" disabled>
                                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    Register
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="cancel_confirmation" tabindex="-1" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cancel Registration?</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>
                    Are you sure you want to cancel the registration for this ticket?
                    All unsaved data will be discarded.
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    No
                </button>
                <button onclick="window.location.href='<?= base_url('user') ?>';" class="btn btn-danger">
                    Yes
                </button>
            </div>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<script>
    $(document).ready(function() {

        setTimeout(() => {
            $('#action_buttons').find('button').prop('disabled', false);
        }, 1000);

        $('form').on('submit', function(event) {

            if ($(this).data('submitted') === true) {
                event.preventDefault();
            } else {
                $(this).data('submitted', true);

                $('#action_buttons').find('button').prop('disabled', true);

                $('#action_buttons').find('button[type="submit"] #submit_spinner').removeClass('d-none');
            }
        });
    });
</script>

<?= $this->endSection() ?>

<?= $this->endSection() ?>