function init_dt_serverside(table_defs) {
  var debug = table_defs.debug ?? false;
  var $table = $(table_defs.table);
  var $dt = null;

  var config = {
    processing: true,
    language: {
      processing:
        "<div class='mb-3 text-secondary fs-6 p-2 text-center'>Loading, please wait...</div>",
    },
    serverSide: true,
    ajax: {
      type: table_defs.type ?? "POST",
    },
    bLengthChange: false,
    layout: {
      topEnd: null,
    },
    searching: false,
    responsive: true,
    rowId: table_defs.rowId ?? "id",
    pageLength: table_defs.rows ?? 10,
    select: table_defs.select ?? {
      style: "multi",
      //blurable: true,
      selector: "td:not(.exclude-select):not(.child)",
    },
    createdRow:
      table_defs.createdRow ??
      function (row, data, dataIndex) {
        $(row).attr("role", "button");
      },
    pagingType: "simple_numbers",
    initComplete: function (settings, json) {
      customPagination(
        settings._iDisplayLength,
        settings._iDisplayStart,
        settings._iRecordsDisplay,
        settings._iRecordsTotal
      );
    },
    drawCallback: function (settings) {
      customPagination(
        settings._iDisplayLength,
        settings._iDisplayStart,
        settings._iRecordsDisplay,
        settings._iRecordsTotal
      );
    },
  };

  table_defs.paging !== null && (config.paging = table_defs.paging);

  config.ajax.url = table_defs.url;
  table_defs.data !== null && (config.ajax.data = table_defs.data);

  table_defs.columns !== null && (config.columns = table_defs.columns);
  table_defs.columnDefs !== null && (config.columnDefs = table_defs.columnDefs);
  table_defs.sort !== null && (config.order = table_defs.sort);

  table_defs.dom !== null && (config.dom = table_defs.dom);
  table_defs.buttons !== null && (config.dom = table_defs.buttons);

  if (debug === true) {
    config.ajax.dataSrc = function (json) {
      console.log("Response from server:", json);
      return json.data;
    };
    config.ajax.error = function (jqXHR, textStatus, errorThrown) {
      console.error(
        "Error occurred during DataTables request:",
        textStatus,
        errorThrown
      );
      console.error("Response from server:", jqXHR.responseText);
    };
    // config.initComplete = function (settings, json) {
    //   console.log("DataTables initialized:", json);
    // };
  }

  $dt = $table.DataTable(config);

  if (debug === true) {
    $dt.on("xhr.dt", function (e, settings, json, xhr) {
      console.log("DataTables xhr event triggered:", json);
    });
  }

  let debounceTimer;

  $("#searchbar").on("input", function () {
    clearTimeout(debounceTimer);

    debounceTimer = setTimeout(() => {
      $dt.draw();
    }, 100);
  });

  $('[data-action="filter"]').change(function () {
    $dt.draw();
  });

  return $dt;
}

function customPagination(pageLength, pageStart, recordsDisplay, recordsTotal) {
  var totalPages = Math.ceil(recordsTotal / pageLength);
  var currentPage = Math.floor(pageStart / pageLength) + 1;

  var paginationHtml = "";
  paginationHtml +=
    '<li class="paginate_button page-item ' +
    (currentPage === 1 ? "disabled" : "") +
    '"><a href="#" class="page-link" data-dt-idx="previous">Previous</a></li>';
  paginationHtml +=
    '<li class="paginate_button page-item ' +
    (currentPage === 1 ? "disabled" : "") +
    '"><a href="#" class="page-link">1</a></li>';

  if (currentPage > 5) {
    paginationHtml +=
      '<li class="paginate_button page-item disabled"><span class="page-link">...</span></li>';
  }

  var startPage = Math.max(currentPage - 2, 2);
  var endPage = Math.min(currentPage + 2, totalPages - 1);

  for (var i = startPage; i <= endPage; i++) {
    paginationHtml +=
      '<li class="paginate_button page-item ' +
      (i === currentPage ? "active" : "") +
      '"><a href="#" class="page-link">' +
      i +
      "</a></li>";
  }

  if (currentPage < totalPages - 4) {
    paginationHtml +=
      '<li class="paginate_button page-item disabled"><span class="page-link">...</span></li>';
  }

  paginationHtml +=
    '<li class="paginate_button page-item ' +
    (currentPage === totalPages ? "disabled" : "") +
    '"><a href="#" class="page-link">' +
    totalPages +
    "</a></li>";
  paginationHtml +=
    '<li class="paginate_button page-item ' +
    (currentPage === totalPages ? "disabled" : "") +
    '"><a href="#" class="page-link" data-dt-idx="next">Next</a></li>';

  $(".dataTables_paginate").html(
    '<ul class="pagination">' + paginationHtml + "</ul>"
  );

  // Bind click event
  $(".pagination a").on("click", function (e) {
    e.preventDefault();
    var pageText = $(this).text();
    var page;
    if ($(this).data("dt-idx") === "previous") {
      page = currentPage - 1;
    } else if ($(this).data("dt-idx") === "next") {
      page = currentPage + 1;
    } else {
      page = parseInt(pageText);
    }
    if (!isNaN(page)) {
      var newStart = (page - 1) * pageLength;
      table.page(newStart / pageLength).draw("page");
    }
  });
}

function getSelectedRows(dataTable, column = null) {
  let selectedRows = dataTable
    .rows({
      selected: true,
    })
    .data()
    .toArray();

  if (column !== null) {
    return selectedRows.map((row) => row[column]);
  }

  return selectedRows;
}

function setActions(dataTable, data, main_url) {
  function showNavbarActions() {
    let selectedRows = getSelectedRows(dataTable, "id");
    if (selectedRows.length > 0) {
      $(".navbar-actions")
        .addClass("show")
        .find("button")
        .prop("disabled", false);
    } else {
      $(".navbar-actions")
        .removeClass("show")
        .find("button")
        .prop("disabled", true);
    }
  }

  $("#table_container").on("click", "tr", showNavbarActions);

  /////// DESELECT ///////
  $(document).on("click", "[data-action='removeSelection']", function () {
    dataTable.rows().deselect();
    $(".navbar-actions")
      .removeClass("show")
      .find("button")
      .prop("disabled", true);
  });

  /////// ACTIVATE ///////
  $(document).on("click", "[data-action='activate']", function () {
    let content = data.activate;
    let entityid = $(this).attr("data-id");

    if (typeof entityid === "undefined") {
      let selectedID = getSelectedRows(dataTable, "id");
      entityid = JSON.stringify(selectedID);
      content = data.activates;
    }

    doAction(dataTable, {
      title: content.title,
      text: content.text,
      confirmButtonText: content.confirmText,
      url: `${main_url}/activate`,
      input: {
        id: entityid,
      },
    });
  });

  /////// DEACTIVATE ///////
  $(document).on("click", "[data-action='deactivate']", function () {
    let content = data.deactivate;
    let entityid = $(this).attr("data-id");

    if (typeof entityid === "undefined") {
      let selectedID = getSelectedRows(dataTable, "id");
      entityid = JSON.stringify(selectedID);
      content = data.deactivates;
    }

    doAction(dataTable, {
      title: content.title,
      text: content.text,
      confirmButtonText: content.confirmText,
      url: `${main_url}/deactivate`,
      input: {
        id: entityid,
      },
    });
  });

  /////// DELETE ///////
  $(document).on("click", "[data-action='delete']", function () {
    let content = data.delete;
    let entityid = $(this).attr("data-id");

    if (typeof entityid === "undefined") {
      let selectedID = getSelectedRows(dataTable, "id");
      entityid = JSON.stringify(selectedID);
      content = data.deletes;
    }

    doAction(dataTable, {
      title: content.title,
      text: content.text,
      confirmButtonText: content.confirmText,
      url: `${main_url}/delete`,
      input: {
        id: entityid,
      },
    });

    showNavbarActions();
  });

  /****************** USERS ********************/

  /////// BAN ///////
  $(document).on("click", "[data-action='ban']", function () {
    let content = data.ban;
    let entityid = $(this).attr("data-id");

    if (typeof entityid === "undefined") {
      let selectedID = getSelectedRows(dataTable, "id");
      entityid = JSON.stringify(selectedID);
      content = data.bans;
    }

    doAction(dataTable, {
      title: content.title,
      text: content.text,
      confirmButtonText: content.confirmText,
      url: `${main_url}/ban`,
      input: {
        id: entityid,
      },
    });
  });

  /////// UNBAN ///////
  $(document).on("click", "[data-action='unban']", function () {
    let content = data.unban;
    let entityid = $(this).attr("data-id");

    if (typeof entityid === "undefined") {
      let selectedID = getSelectedRows(dataTable, "id");
      entityid = JSON.stringify(selectedID);
      content = data.unbans;
    }

    doAction(dataTable, {
      title: content.title,
      text: content.text,
      confirmButtonText: content.confirmText,
      url: `${main_url}/unban`,
      input: {
        id: entityid,
      },
    });
  });

  /***************** TICKETS *******************/

  if (data.resendqr !== null) {
    /////// RESEND QR ///////
    $(document).on("click", "[data-action='resendqr']", function () {
      let content = data.resendqr;
      let entityid = $(this).attr("data-id");

      if (typeof entityid === "undefined") {
        let selectedID = getSelectedRows(dataTable, "id");
        entityid = JSON.stringify(selectedID);
        data.resendqrs !== null && (content = data.resendqrs);
      }

      doAction(dataTable, {
        title: content.title,
        text: content.text,
        confirmButtonText: content.confirmText,
        url: `${main_url}/resendQR`,
        input: {
          id: entityid,
        },
      });
    });
  }

  /***************** LOGS *******************/

  /////// CLEAR ///////
  $(document).on("click", "[data-action='clear']", function () {
    let content = data.clear;

    doAction(dataTable, {
      title: content.title,
      text: content.text,
      confirmButtonText: content.confirmText,
      url: `${main_url}/clear`,
    });
  });
}

function doAction(dataTable, action_def) {
  Swal.fire({
    title: action_def.title ?? "Are You Sure?",
    html: action_def.text ?? "Do you really want to do this?",
    icon: action_def.icon ?? "question",
    showCancelButton: true,
    confirmButtonText: action_def.confirmButtonText ?? null,
    showLoaderOnConfirm: true,
    preConfirm: async () => {
      try {
        const response = await fetch(action_def.url, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            "X-Requested-With": "XMLHttpRequest",
          },
          body: JSON.stringify(action_def.input ?? ""),
        });
        if (!response.ok) {
          console.error(await response.json());
          return Swal.showValidationMessage("Something went wrong");
        }
        return response.json();
      } catch (error) {
        console.error(error);
        Swal.showValidationMessage("Request failed");
      }
    },
    allowOutsideClick: () => !Swal.isLoading(),
  }).then((result) => {
    if (result.isConfirmed) {
      let response = result.value;
      Swal.fire({
        title: response.title,
        text: response.data,
        icon: response.success ? "success" : "error",
      });

      if (typeof dataTable !== "undefined" && dataTable != null) {
        dataTable.draw();
      }
    }
  });
}
