/**
 * Custom Sneat Elements
 */

"use strict";

// Back to Top Button
(function () {
  //Get the button
  var container = document.getElementById("back-to-top");
  var button = container.querySelector(".btn-back-to-top");
  var footer = document.querySelector("footer");

  container.style.height = `${getOffsetHeight(button)}px`;

  // When the user scrolls down 20px from the top of the document, show the button
  window.onscroll = function () {
    if (
      document.body.scrollTop > 20 ||
      document.documentElement.scrollTop > 20
    ) {
      button.style.visibility = "visible";
      button.style.opacity = 1;
    } else {
      button.style.visibility = "hidden";
      button.style.opacity = 0;
    }

    // When the user clicks on the button, scroll to the top of the document
    button.addEventListener("click", backToTop);
  };

  repositionButton();

  window.addEventListener("resize", repositionButton);

  function backToTop() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  }

  function getOffsetHeight(el) {
    var hh = 0;
    if (el) {
      hh = el.clientHeight;
      var computedStyle = getComputedStyle(el);
      var paddingTop = parseInt(computedStyle.paddingTop) || 0;
      var paddingBottom = parseInt(computedStyle.paddingBottom) || 0;
      hh += paddingTop + paddingBottom;
    }
    return hh;
  }

  function repositionButton() {
    var offset = 10;
    var size = getOffsetHeight(footer) + offset;
    button.style.bottom = `${size}px`;
  }
})();

// Responsive search bar
(function () {
  // var searchbar = container.querySelector(".main-searchbar");
  // var button = container.querySelector(".activate-searchbar");
})();
