<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');

// $routes->get('oauth', 'OauthController::index');
// $routes->get('oauth/callback', 'OauthController::callback');
// $routes->post('sendgrid/webhook', 'SendGridController::webhook');

service('auth')->routes($routes,  ['except' => ['login', /*'register'*/]]);

// $routes->group('test', function ($routes) {

//     $routes->get('/', 'TestController::index');
//     $routes->get('decrypt/(:any)', 'TestController::decrypt/$1');
//     $routes->get('verifyTicket/(:any)', 'TestController::verifyTicket/$1');
// });

$routes->group('', ['namespace' => 'App\Controllers\Shield'], function ($routes) {

    $routes->get('login', 'LoginController::LoginView');
    $routes->post('login', 'LoginController::LoginAction');
});

$routes->group('', ['namespace' => 'App\Controllers\Api'], function ($routes) {

    $routes->group(MY_SEGMENT, function ($routes) {

        $routes->group(PROFILE_SEGMENT, function ($routes) {
            $routes->get('/', 'ProfileController::viewProfile');
            $routes->get('activity', 'ProfileController::viewActivity');
            $routes->post('update', 'ProfileController::updateProfile');
            $routes->post('update/password', 'ProfileController::changePassword');
        });

        $routes->group(SETTINGS_SEGMENT, function ($routes) {
            $routes->get('/', 'ProfileController::viewSettings');
            $routes->get('update', 'ProfileController::updateSettings');
        });
    });

    $routes->group(DASHBOARD_SEGMENT, function ($routes) {
        $routes->get('/', 'DashboardController::index');
        $routes->get('fetchData', 'DashboardController::fetchData');
    });

    $routes->group(BRANCH_SEGMENT, function ($routes) {

        // View list
        $routes->get('/', 'BranchController::index');
        $routes->post('fetchAll', 'BranchController::listAction');

        // Create action
        $routes->get('create', 'BranchController::createView');
        $routes->post('store', 'BranchController::createAction');

        // Edit action
        $routes->get('edit/(:num)', 'BranchController::editView/$1');
        $routes->post('update/(:num)', 'BranchController::editAction/$1');

        // Other post method actions
        $routes->post('delete', 'BranchController::delete');
        $routes->post('deactivate', 'BranchController::deactivate');
        $routes->post('activate', 'BranchController::activate');
    });

    $routes->group(EVENT_SEGMENT, function ($routes) {

        // View list
        $routes->get('/', 'EventController::index');
        $routes->post('fetchAll', 'EventController::listAction');

        // Create action
        $routes->get('create', 'EventController::createView');
        $routes->post('store', 'EventController::createAction');

        // Edit action
        $routes->get('edit/(:num)', 'EventController::editView/$1');
        $routes->post('update/(:num)', 'EventController::editAction/$1');

        // Other post method actions
        $routes->post('delete', 'EventController::delete');
        $routes->post('deactivate', 'EventController::deactivate');
        $routes->post('activate', 'EventController::activate');
    });

    $routes->group(LOG_SEGMENT, function ($routes) {

        // View list
        $routes->get('/', 'LogController::index');
        $routes->post('fetchAll', 'LogController::listAction');
        $routes->post('clear', 'LogController::clear');
    });

    $routes->group(TICKET_SEGMENT, function ($routes) {

        // View list
        $routes->get('/', 'TicketController::index');
        $routes->post('fetchAll', 'TicketController::listAction');

        // Create action
        $routes->get('register', 'TicketController::createView');
        $routes->post('store', 'TicketController::createAction');

        // Edit action
        $routes->get('edit/(:num)', 'TicketController::editView/$1');
        $routes->post('update', 'TicketController::editAction');

        // Validation action
        $routes->get('validation', 'TicketController::validationView');
        $routes->get('validation/(:any)', 'TicketController::validationView/$1');
        $routes->post('validate', 'TicketController::validationAction');
        $routes->post('trackTime', 'TicketController::trackTime');
        // $routes->post('attendance', 'TicketController::trackAttendance');
        // $routes->post('leave', 'TicketController::trackLeave');

        // // Other get method actions
        // $routes->get('fetch/(:segment)/(:any)', 'TicketController::fetchOptions/$1/$2');
        // $routes->get('fetch/(:segment)/(:any)/(:any)', 'TicketController::fetchOptions/$1/$2/$3');
        $routes->get('fetchDynamic', 'TicketController::fetchDynamic');

        // Other post method actions
        $routes->post('delete', 'TicketController::delete');
        $routes->post('resendQR', 'TicketController::resendQRCode');

        $routes->get('check-duplicates', 'TicketController::ticketConflictChecker');
    });

    $routes->group(USER_SEGMENT, function ($routes) {

        // View list
        $routes->get('/', 'UserController::index');
        $routes->post('fetchAll', 'UserController::listAction');

        // Create action
        $routes->get('create', 'UserController::createView');
        $routes->post('store', 'UserController::createAction');

        // Edit action
        $routes->get('edit/(:num)', 'UserController::editView/$1');
        $routes->post('update/(:num)', 'UserController::editAction/$1');

        // Other post method actions
        $routes->post('activate', 'UserController::activate');
        $routes->post('deactivate', 'UserController::deactivate');
        $routes->post('delete', 'UserController::delete');
        $routes->post('ban', 'UserController::ban');
        $routes->post('unban', 'UserController::unban');
    });

    $routes->group(REPORT_SEGMENT, function ($routes) {

        // View reports
        $routes->get('/', 'ReportController::list');
        $routes->post('retrieve', 'ReportController::generate');
    });
});

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
