<?php

namespace App\Models;

use CodeIgniter\Model;

class LogModel extends Model
{
    protected $table            = 'logs';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['timestamp', 'action', 'entity_id', 'module', 'performed_by'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Log action to database
    public function logAction($action, $entityId, $module)
    {
        $logData = [
            //'timestamp' => date('Y-m-d H:i:s'),
            'action' => $action,
            'entity_id' => $entityId,
            'module' => $module,
            'performed_by' => user_id(),
        ];

        $this->insert($logData);
    }

    public function truncateTable()
    {
        $this->db->query('TRUNCATE TABLE ' . $this->table);
    }
}
