<?php

namespace App\Models;

use CodeIgniter\Model;

class Schedule extends Model
{
    protected $table            = 'schedules';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = (ENVIRONMENT === 'production');
    protected $protectFields    = true;
    protected $allowedFields    = [];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = ['logInsert'];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = ['logUpdate'];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = ['logDelete'];

    // Flags
    protected $skipLogAction  = false;

    // Log callback methods
    protected function logInsert(array $data)
    {
        $this->logAction('insert', $data['id']);
        return $data;
    }

    protected function logUpdate(array $data)
    {
        $this->logAction('update', $data['id']);
        return $data;
    }

    protected function logDelete(array $data)
    {
        $this->logAction('delete', $data['id']);
        return $data;
    }

    protected function skipLog(callable $callback)
    {
        // Update skipLogAction flag first
        $this->skipLogAction = true;

        try {
            return $callback();
        } finally {
            // Reset to original state
            $this->skipLogAction = false;
        }
    }

    protected function logAction($action, $entityId)
    {
        if ($this->skipLogAction) {
            return;
        }

        $logsModel = new LogModel();
        $logsModel->logAction($action, $entityId, $this->table);
    }
}
