<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> New Branch <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0">Add New Branch</h5>
            </div>
            <div class="card-body">
                <form action="<?= current_url() ?>" method="post">
                    <?= csrf_field() ?>
                    <div style="max-width: 600px;">
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="branchCode">Branch Code</label>
                            <div class="col-sm-9">
                                <input type="text" name="branchCode" class="form-control" id="branchCode" placeholder="Enter branch code" value="<?= old('branchCode') ?>" autofocus required />
                                <small class="text-danger"><?= session()->getFlashdata('error')['branch_code'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="branchName">Branch Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="branchName" class="form-control" id="branchName" placeholder="Enter branch name" value="<?= old('branchName') ?>" required />
                                <small class="text-danger"><?= session()->getFlashdata('error')['branch_name'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="active">Active</label>
                            <div class="col-sm-9">
                                <div class="form-check form-switch">
                                    <input type="checkbox" name="active" class="form-check-input" role="switch" id="active" value="1" <?= old('active') ? 'checked' : '' ?> />
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <div class="d-flex align-items-center gap-2">
                                    <a href="<?= base_url('branch') ?>" class="btn btn-outline-secondary">Cancel</a>
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>