<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Edit Event <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0">Edit Event</h5>
            </div>
            <div class="card-body">
                <form action="<?= current_url() ?>" method="post">
                    <?= csrf_field() ?>
                    <div style="max-width: 600px;">
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="eventCode">Event Code</label>
                            <div class="col-sm-9">
                                <input type="text" name="eventCode" class="form-control" id="eventCode" placeholder="Enter event code" value="<?= old('eventCode', $event['event_code']) ?>" disabled />
                                <small class="text-danger"><?= session()->getFlashdata('error')['event_code'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="eventName">Event Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="eventName" class="form-control" id="eventName" placeholder="Enter event name" value="<?= old('eventName', $event['event_name']) ?>" autofocus required />
                                <small class="text-danger"><?= session()->getFlashdata('error')['event_name'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="eventDescription">Description</label>
                            <div class="col-sm-9">
                                <textarea name="eventDescription" class="form-control" id="eventDescription" rows="3" placeholder="A brief description of the event..."><?= old('eventDescription', $event['event_description']) ?></textarea>
                                <small class="text-danger"><?= session()->getFlashdata('error')['event_description'] ?? '' ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                                <label class="col-sm-3 col-form-label" for="active">Active</label>
                                <div  class="col-sm-9">
                                    <div class="form-check form-switch">
                                        <input type="checkbox" name="active" class="form-check-input" role="switch" id="active" value="1" <?= old('active', $event['active']) ? 'checked' : '' ?> />
                                    </div>
                                </div>
                            </div>
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <div class="d-flex align-items-center gap-2">
                                    <a href="<?= base_url('event') ?>" class="btn btn-outline-secondary">Cancel</a>
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>