<?php

/** @var Config\RiceData $config */
$config = config('RiceData');

?>

<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Edit Ticket <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<?= $this->include('partials/css/select2') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <h5 class="card-header">Edit Ticket</h5>
            <div class="card-body">
                <form>
                    <?= csrf_field() ?>
                    <input type="hidden" name="id" value="<?= old('id', $ticket->id) ?>">

                    <p id="description">
                        <span class="desc-helper text-secondary">Change the data needed for correction or edit.</span>
                        <span class="desc-error text-danger d-none"></span>
                    </p>

                    <hr class="my-4 mx-n4">
                    <h6>1. Owner's Name</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="first_name">First Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="first_name" class="form-control" id="first_name" placeholder="Enter first name" value="<?= old('first_name', $ticket->first_name) ?>" autofocus />
                            <small class="text-danger input-error" data-for="first_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="first_name"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="last_name">Last Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="last_name" class="form-control" id="last_name" placeholder="Enter last name" value="<?= old('last_name', $ticket->last_name) ?>" />
                            <small class="text-danger input-error" data-for="last_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="last_name"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="middle_name">Middle Name (Optional)</label>
                        <div class="col-sm-9">
                            <input type="text" name="middle_name" class="form-control" id="middle_name" placeholder="Enter middle name (optional)" value="<?= old('middle_name', $ticket->middle_name) ?>" />
                            <small class="text-danger input-error" data-for="middle_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="middle_name"></small>
                        </div>
                    </div>

                    <hr class="my-4 mx-n4">
                    <h6>2. Other Details</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="id_number">Valid ID Number</label>
                        <div class="col-sm-9">
                            <input type="text" name="id_number" class="form-control" id="id_number" placeholder="Enter valid ID number" value="<?= old('id_number', $ticket->id_number) ?>" />
                            <small class="text-danger input-error" data-for="id_number"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="id_number">
                                Can be an LRN, student number, or any valid ID number
                            </small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="branch_id">Branch</label>
                        <div class="col-sm-9">
                            <?php $branch = model('BranchModel')->find($ticket->branch_id) ?>
                            <input type="text" class="form-control" value="<?= $branch ? $branch->branch_name : '' ?>" disabled>
                            <small class="text-danger input-error" data-for="branch_id"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="branch_id"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="position">Position</label>
                        <div class="col-sm-9">
                            <select name="position" id="position" class="form-select select2" data-hint="Select position">
                                <option value="">Select position</option>
                                <?php foreach ($config->getPositionList() as $position => $description) : ?>
                                    <option value="<?= $position ?>" <?= $position == old('position', $ticket->position) ? 'selected' : '' ?>><?= $description ?></option>
                                <?php endforeach ?>
                            </select>
                            <small class="text-danger input-error" data-for="position"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="position"></small>
                        </div>
                    </div>
                    <?php $isDeptExist = !empty($departments = $config->getDepartmentList(old('position', $ticket->position))) ?>
                    <div class="row mb-3 <?= !$isDeptExist ? 'd-none' : '' ?>" id="department_container">
                        <label class="col-sm-3 col-form-label" for="department">Department</label>
                        <div class="col-sm-9">
                            <select name="department" id="department" class="form-select select2" <?= !$isDeptExist ? 'disabled' : '' ?> data-hint="Select department">
                                <option value="">Select department</option>
                                <?php foreach ($departments as $department => $description) : ?>
                                    <option value="<?= $department ?>" <?= $department == old('department', $ticket->department) ? 'selected' : '' ?>><?= $description ?></option>
                                <?php endforeach ?>
                            </select>
                            <small class="text-danger input-error" data-for="department"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="department"></small>
                        </div>
                    </div>
                    <?php $isYearExist = !empty($years = $config->getYearList(old('position', $ticket->position), old('department', $ticket->department))) ?>
                    <?php $yearLabel = $isYearExist ? $config->getYearCategory(old('position', $ticket->position), old('department', $ticket->department)) : 'level' ?>
                    <div class="row mb-3 <?= !$isYearExist ? 'd-none' : '' ?>" id="year_container">
                        <label class="col-sm-3 col-form-label" for="year"><?= $yearLabel ?></label>
                        <div class="col-sm-9">
                            <select name="year" id="year" class="form-select select2" <?= !$isYearExist ? 'disabled' : '' ?> data-hint="Select <?= $yearLabel ?>">
                                <option value="">Select <?= $yearLabel ?></option>
                                <?php foreach ($years as $year) : ?>
                                    <option value="<?= $year ?>" <?= $year == old('year', $ticket->year) ? 'selected' : '' ?>><?= $year ?></option>
                                <?php endforeach ?>
                            </select>
                            <small class="text-danger input-error" data-for="year"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="year"></small>
                        </div>
                    </div>
                    <?php $isTrackExist = !empty($tracks = $config->getTrackList(old('position', $ticket->position), old('department', $ticket->department))) ?>
                    <?php $trackLabel = $isTrackExist ? $config->getTrackCategory(old('position', $ticket->position), old('department', $ticket->department)) : 'strand/course' ?>
                    <div class="row mb-3 <?= !($isTrackApplicable = $isTrackExist && $isYearExist) ? 'd-none' : '' ?>" id="track_container">
                        <label class="col-sm-3 col-form-label" for="track"><?= $trackLabel ?></label>
                        <div class="col-sm-9">
                            <select name="track" id="track" class="form-select select2" <?= !$isTrackApplicable ? 'disabled' : '' ?> data-hint="Select <?= $trackLabel ?>">
                                <option value="">Select <?= $trackLabel ?></option>
                                <?php foreach ($tracks as $track => $description) : ?>
                                    <option value="<?= $track ?>" <?= $track == old('track', $ticket->track) ? 'selected' : '' ?>><?= "{$description} ({$track})" ?></option>
                                <?php endforeach ?>
                            </select>
                            <small class="text-danger input-error" data-for="track"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="track"></small>
                        </div>
                    </div>

                    <hr class="my-4 mx-n4">
                    <h6>3. Contact Info</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="email">Email Address</label>
                        <div class="col-sm-9">
                            <input type="email" name="email" class="form-control" id="email" placeholder="Enter email" value="<?= old('email', $ticket->email) ?>" />
                            <small class="text-danger input-error" data-for="email"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="email">
                                Must be valid as ticket QR code will be sent to this email
                            </small>
                        </div>
                    </div>
                    <div class="row mb-3 d-none">
                        <label class="col-sm-3 col-form-label" for="phone_number">Contact Number (Optional)</label>
                        <div class="col-sm-9">
                            <input type="text" name="phone_number" class="form-control" id="phone_number" placeholder="Enter contact number (optional)" value="<?= old('phone_number', $ticket->phone_number) ?>" disabled />
                            <small class="text-danger input-error" data-for="phone_number"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="phone_number"></small>
                        </div>
                    </div>

                    <hr class="my-4 mx-n4">
                    <h6>4. Requirements Status</h6>

                    <div class="mb-4">
                        <div class="form-check">
                            <input type="checkbox" name="req_submitted" class="form-check-input" id="req_submitted" value="1" <?= old('req_submitted', $ticket->req_submitted) ? 'checked' : '' ?> />
                            <label class="form-check-label" for="req_submitted">I hereby confirm that the owner of this ticket has already submitted his or her requirements. (Please leave unchecked if not).</label>
                        </div>
                    </div>

                    <div class="row justify-content-end" id="actionButtons">
                        <div class="col">
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-outline-secondary" data-toggle="cancel" disabled>
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-primary d-flex align-items-center gap-2" disabled>
                                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    Update
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/form-select select2/form-select select2.min.js"></script>
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/js/swal2_init.js"></script>
<script src="/assets/js/form_helper.js"></script>

<?= $this->include('partials/js/select2') ?>

<script type="text/javascript">
    $(document).ready(function() {

        $.getJSON('<?= ticket_url('fetchDynamic') ?>', function(data) {

                var $position = $('#position');
                var $positionCon = $('#position_container');
                var $department = $('#department');
                var $departmentCon = $('#department_container');
                var $year = $('#year');
                var $yearCon = $('#year_container');
                var $track = $('#track');
                var $trackCon = $('#track_container');

                if ($.isEmptyObject(data) === false) {
                    $('#position').change(function() {
                        disableDynamicField($departmentCon, $department);
                        disableDynamicField($yearCon, $year);
                        disableDynamicField($trackCon, $track);

                        let departments = data.department[$position.val()] ?? [];

                        if ($.isEmptyObject(departments) === false) {

                            enableDynamicField($departmentCon, $department);
                            $department.append('<option value="">Select department</option>');

                            $.each(departments, function(key, value) {
                                $department.append(`<option value="${key}">${value}</option>`);
                            });
                        }
                    });

                    $('#department').change(function() {
                        let $yearLabel = $('label[for="year"]');
                        let $trackLabel = $('label[for="track"]');

                        disableDynamicField($yearCon, $year);
                        disableDynamicField($trackCon, $track);

                        let years = data.year[$position.val()][$department.val()] ?? [];

                        if ($.isEmptyObject(years) === false) {
                            let yearLabel = data.yearLabel[$position.val()][$department.val()] ?? 'year';

                            enableDynamicField($yearCon, $year);
                            $yearLabel.text(yearLabel);
                            $year.append(`<option value="">Select ${yearLabel}</option>`);
                            $year.Select2UpdatePlaceholder(`Select ${yearLabel}`);

                            $.each(years, function(index, value) {
                                $year.append(`<option value="${value}">${value}</option>`);
                            });
                        }

                        let tracks = data.track[$position.val()][$department.val()] ?? [];

                        if ($.isEmptyObject(tracks) === false) {
                            let trackLabel = data.trackLabel[$position.val()][$department.val()] ?? 'track';

                            enableDynamicField($trackCon, $track);
                            $trackLabel.text(trackLabel);
                            $track.append(`<option value="">Select ${trackLabel}</option>`);
                            $track.Select2UpdatePlaceholder(`Select ${trackLabel}`);

                            $.each(tracks, function(key, value) {
                                $track.append(`<option value="${key}">${value} (${key})</option>`);
                            });
                        }
                    });
                }

            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.error('Error fetching data: ' + textStatus, errorThrown);
            });

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            let data = response.ticket;
            setCancelButton(data, "<?= ticket_url() ?>");
            setRequest(data, "<?= ticket_url("update") ?>", "<?= ticket_url() ?>");
        });

        function disableDynamicField(container, select) {
            container.addClass('d-none');
            select.empty().prop('disabled', true);
        }

        function enableDynamicField(container, select) {
            container.removeClass('d-none');
            select.prop('disabled', false);
        }
    });
</script>

<?= $this->endSection() ?>

<?= $this->endSection() ?>