<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Ticket List <?= $this->endSection() ?>

<?= $this->section('entity') ?> Ticket <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link href="/assets/vendor/DataTables/datatables.css" rel="stylesheet">
<style>
    .marquee {
        height: 1rem;
        overflow: hidden;
        position: relative;
        white-space: nowrap;
    }

    .marquee>* {
        display: block;
        position: absolute;
        width: max-content;
        height: 100%;
        margin: 0;
        text-align: center;
    }

    .marquee.start>* {
        /* Start off the right edge */
        transform: translateX(100%);
        /* Animate to the left */
        animation: scroll-left 10s linear infinite;
    }

    @-moz-keyframes scroll-left {
        0% {
            -moz-transform: translateX(100%);
        }

        100% {
            -moz-transform: translateX(-100%);
        }
    }

    @-webkit-keyframes scroll-left {
        0% {
            -webkit-transform: translateX(100%);
        }

        100% {
            -webkit-transform: translateX(-100%);
        }
    }

    @keyframes scroll-left {
        0% {
            -moz-transform: translateX(100%);
            -webkit-transform: translateX(100%);
            transform: translateX(100%);
        }

        100% {
            -moz-transform: translateX(-100%);
            -webkit-transform: translateX(-100%);
            transform: translateX(-100%);
        }
    }
</style>

<?= $this->endSection() ?>

<?= $this->section('navbar-items') ?>

<li class="nav-item lh-1 me-2 navbar-actions" id="selectionActions">
    <div class="d-none d-sm-block">
        <div class="btn-group" role="group" aria-label="Toolbar">
            <button type="button" class="btn btn-outline-secondary px-2" data-action="removeSelection" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remove Selection" disabled>
                <i class="tf-icons bx bx-x"></i>
            </button>
            <button type="button" class="btn btn-outline-secondary px-2" data-action="resendqr" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remail QR Codes" disabled>
                <i class="tf-icons bx bx-envelope"></i>
            </button>
            <?php if (auth()->loggedIn() && auth()->user()->can('tickets.delete')) : ?>
                <button type="button" class="btn btn-outline-secondary px-2" data-action="delete" data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="bottom" data-bs-html="false" data-bs-original-title="Remove Tickets" disabled>
                    <i class="tf-icons bx bx-trash"></i>
                </button>
            <?php endif ?>
        </div>
    </div>
    <div class="d-block d-sm-none nav-item navbar-dropdown dropdown">
        <button type="button" class="btn btn-secondary btn-icon rounded-pill dropdown-toggle hide-arrow" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bx bx-dots-vertical-rounded"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end">
            <li>
                <button class="dropdown-item" data-action="removeSelection" disabled>
                    <i class="bx bx-x me-1"></i>
                    Remove Selection
                </button>
            </li>
            <li>
                <button class="dropdown-item" data-action="resendqr" disabled>
                    <i class="bx bx-envelope me-1"></i>
                    Remail QR Codes
                </button>
            </li>
            <?php if (auth()->loggedIn() && auth()->user()->can('tickets.delete')) : ?>
                <li>
                    <button class="dropdown-item" data-action="delete" disabled>
                        <i class="bx bx-trash me-1"></i>
                        Remove Tickets
                    </button>
                </li>
            <?php endif ?>
        </ul>
    </div>
</li>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header">
        <h5>Ticket Management</h5>

        <?= $this->include('partials/elements/common/alert') ?>

        <div class="row gy-3">
            <div class="col">
                <form id="recordfilter" method="post">
                    <div class="d-flex align-items-center gap-2 row-gap-2 flex-wrap">
                        <div class="mb-2">
                            <i class='bx bx-filter'></i>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="branch" id="branch">
                                <option value="">All Branch</option>
                                <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                    <option value="<?= $branch->id ?>"><?= $branch->branch_name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="position" id="position">
                                <option value="">All Position</option>
                                <?php foreach (setting('RiceData.positionDetails') as $position => $desc) : ?>
                                    <option value="<?= $position ?>"><?= $desc ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="department" id="department">
                                <option value="">All Department</option>
                                <?php foreach (setting('RiceData.departmentDetails') as $department => $desc) : ?>
                                    <option value="<?= $department ?>"><?= $desc ?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <div class="flex-fill flex-md-grow-0">
                            <select class="form-select" data-action="filter" name="requirements" id="requirements">
                                <option value="">All Requirement Status</option>
                                <option value="1">Submitted</option>
                                <option value="0">Not Submitted</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-auto">
                <div class="">
                    <a href="<?= ticket_url('register') ?>" class="btn btn-primary" tabindex="0">
                        <span><i class="bx bx-plus me-sm-1"></i></span>
                        <span class="d-inline-block">Register Ticket</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div id="table_container" class="">
        <table id="ticket_table" class="table table-striped nowrap table-sm" style="width: 100%;">
            <thead>
                <tr>
                    <th></th>
                    <th class="col_code">#</th>
                    <!--<th class="col_tktnum">Ticket Number</th>-->
                    <th class="col_ticketnum">Ticket Number</th>
                    <th class="col_name">Name</th>
                    <th class="col_branch">Branch</th>
                    <th class="col_position">Position</th>
                    <th class="col_req">Requirements</th>
                    <th class="col_modified_at">Date Modified</th>
                    <th class="col_attend">Attd</th>
                    <th class="col_leave">Left</th>
                    <th class="col_action"></th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/vendor/DataTables/datatables.js"></script>
<script src="/assets/js/dt_swal2_init.js"></script>

<?= $this->include('partials/js/offcanvas') ?>

<script type="text/javascript">
    $(document).ready(function() {
        var dataTable = init_dt_serverside({
            table: "#ticket_table",
            debug: <?= (ENVIRONMENT !== 'production') ? 'true' : 'false' ?>,
            url: "<?= ticket_url('fetchAll') ?>",
            data: function(d) {
                d.new_search = $('#searchbar').val();
                d.filter = $('#recordfilter').serialize();

                <?= (ENVIRONMENT !== 'production') ? 'console.log("Parameters:", d);' : '' ?>
            },
            columns: [{
                    data: null,
                    defaultContent: '',
                    orderable: false,
                    className: 'exclude-select pe-0',
                    responsivePriority: 2,
                },
                {
                    data: '',
                    name: '',
                },
                {
                    data: 'ticket_number',
                    name: 'tickets.ticket_number',
                    responsivePriority: 2,
                },
                // {
                //     data: 'ticket_number',
                //     name: 'ticket_number',
                //     responsivePriority: 1,
                // },
                {
                    data: 'name',
                    name: 'tickets.first_name',
                    responsivePriority: 1,
                },
                {
                    data: 'branch_name',
                    orderable: false,
                },
                {
                    data: 'role',
                    orderable: false,
                },
                {
                    data: 'requirements',
                    orderable: false,
                },
                {
                    data: 'updated_at',
                    name: 'updated_at',
                },
                {
                    data: 'attended',
                    orderable: false,
                },
                {
                    data: 'leaved',
                    orderable: false,
                },
                {
                    data: 'action',
                    responsivePriority: 2,
                    orderable: false,
                    className: 'exclude-select',
                }
            ],
            columnDefs: [{
                targets: '_all',
                className: 'dt-head-left dt-body-left align-middle',
            }],
            rows: 50,
            sort: {
                name: 'updated_at',
                dir: 'desc',
            },
            filtering: true
        });

        //var selectedData = getSelectedRows(dataTable);

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            const data = response.ticket;
            setActions(dataTable, data, "<?= ticket_url() ?>");
        });

        function marquee() {
            $('.marquee').each(function() {
                const $this = $(this);
                const $child = $this.children().first();
                if ($child.outerWidth() > $this.innerWidth()) {
                    $this.addClass('start');
                } else {
                    $this.removeClass('start');
                }
            });
        }

        $(window).on('resize', marquee);
        setTimeout(marquee, 2500);
    });
</script>

<?= $this->endSection() ?>