<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> User Accounts <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header row align-items-center">
        <div class="col-md-auto text-center">
            <h4 class="card-title m-0">User Management</h4>
        </div>
        <div class="col-md-auto ms-auto pt-3 pt-md-0">
            <div class="row flex-wrap">
                <form class="col" method="post">
                    <div class="input-group input-group-merge">
                        <button type="submit" class="input-group-text">
                            <i class="bx bx-search"></i>
                        </button>
                        <input type="search" name="search" class="form-control" placeholder="Search..." aria-label="Search..." value="<?= $search ?? '' ?>" autofocus />
                    </div>
                </form>
                <div class="col-auto">
                    <a href="<?= base_url('user/create') ?>" class="btn btn-primary" tabindex="0">
                        <span><i class="bx bx-plus me-sm-1"></i></span>
                        <span class="d-none d-sm-inline-block">Add New User</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Branch</th>
                    <th>Group</th>
                    <th>Active</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">

                <?php if (!empty($users)) : foreach ($users as $row) : ?>

                        <tr>
                            <td>
                                <div class="fw-bold">
                                    <?php
                                    $fullname = $row->first_name . ' ' . (!empty($row->middle_name) ? $row->middle_name[0] . '. ' : '') . $row->last_name;
                                    if (empty(trim($fullname))) {
                                        echo 'No Name';
                                    } else {
                                        echo $fullname;
                                    }
                                    ?>
                                </div>
                                <small>@<?= $row->username ?></small>
                            </td>
                            <td><?= $row->email ?></td>
                            <td><?= $row->branch_name ? $row->branch_name : 'None' ?></td>
                            <td><?= $row->group ?></td>
                            <td>
                                <?php if ($row->active) : ?>

                                    <i class="bx bx-check text-success"></i>

                                <?php else : ?>

                                    <i class="bx bx-x text-danger"></i>

                                <?php endif ?>
                            </td>
                            <td>
                                <div class="dropdown position-static">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="user/edit/<?= $row->id ?>">
                                            <i class="bx bx-edit-alt me-1"></i>
                                            Edit
                                        </a>
                                        <a class="dropdown-item" href="user/delete/<?= $row->id ?>">
                                            <i class="bx bx-trash me-1"></i>
                                            Delete
                                        </a>
                                    </div>
                                </div>
                            </td>
                        </tr>

                    <?php endforeach;
                else : ?>

                    <tr>
                        <td colspan="6" class="text-danger text-center">No data found in table.</td>
                    </tr>

                <?php endif; ?>

            </tbody>
        </table>
    </div>
    <div class="card-footer pt-3 pb-1">
        <div id="pagination-links">
            <?= $pagination_link ?? '' ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>