$(document).ready(function () {
  $("input[autofocus]").each(function () {
    let input = $(this);
    let value = input.val();
    input.focus().val("").val(value);
  });

  setTimeout(() => {
    $("#actionButtons").find("button").prop("disabled", false);
  }, 800);

  $("form")
    .find("input, select, textarea")
    .on("input change", function () {
      setError($(this).attr("name"), "");
    });
});

function setError(field, text = "") {
  $(`.input-error[data-for="${field}"]`).text(text);
  if (text == "") {
    $(`.input-helper[data-for="${field}"]`).css("display", "inline");
  } else {
    $(`.input-helper[data-for="${field}"]`).css("display", "none");
  }
}

function disableButtons(value = true, processing = false) {
  $buttons = $("#actionButtons");
  $buttons.find("button").prop("disabled", value);
  if (processing === true) {
    $buttons
      .find('button[type="submit"] #submit_spinner')
      .removeClass("d-none");
  } else {
    $buttons.find('button[type="submit"] #submit_spinner').addClass("d-none");
  }
}

function setCancelButton(data, main_url) {
  $('[data-toggle="cancel"]').click(function () {
    const content = data.cancelRegistration;
    Swal.fire({
      title: content.title,
      html: content.text,
      icon: content.icon,
      showCancelButton: true,
      confirmButtonText: content.confirmText,
      cancelButtonText: content.cancelText,
    }).then((result) => {
      if (result.isConfirmed) {
        disableButtons(true, false);
        window.location.href = main_url;
      }
    });
  });
}

function setRequest(data, serverUrl, mainUrl, form = "") {
  const content = data.edit;

  targetForm = form !== null && form !== "" ? form : "form";

  $(targetForm).on("submit", function (e) {
    e.preventDefault();

    disableButtons(true, true);

    $.ajax({
      url: serverUrl,
      method: "post",
      data: $(this).serialize(),
      dataType: "json",
      success: function (response) {
        console.log(response);
        if (response.success) {
          window.location.href = mainUrl;
        } else {
          if (response.data !== null) {
            let data = response.data;
            let list =
              typeof data === "object"
                ? `<ul>${Object.entries(data)
                    .map(([key, value]) =>
                      value !== null && value !== "" ? `<li>${value}</li>` : ""
                    )
                    .join("")}</ul>`
                : data;

            if (list !== "") {
              $("#description")
                .find(".desc-helper")
                .addClass("d-none")
                .end()
                .find(".desc-error")
                .html(list)
                .removeClass("d-none");
              $("html, body").animate({ scrollTop: 0 }, "fast");
            }
          } else {
            $("#description")
              .find(".desc-helper")
              .removeClass("d-none")
              .end()
              .find(".desc-error")
              .addClass("d-none");
          }

          if (response.errors !== null) {
            $.each(response.errors, function (key, value) {
              setError(key, value);
            });

            $(".input-error").each(function () {
              let field = $(this).attr("data-for");
              if ($(this).text() !== "") {
                $(`#${field}`).focus();
                return false;
              }
            });
          }

          disableButtons(false, false);
        }
      },
      error: function (xhr, status, error) {
        Swal.fire({
          title: "Error",
          html: content.errorText,
          icon: "error",
        });
        console.error("An error occurred: " + error);
        disableButtons(false, false);
      },
    });
  });
}
