<?php

declare(strict_types=1);

/**
 * This file is part of CodeIgniter Shield.
 *
 * (c) CodeIgniter Foundation <admin@codeigniter.com>
 *
 * For the full copyright and license information, please view
 * the LICENSE file that was distributed with this source code.
 */

namespace Config;

use CodeIgniter\Shield\Config\AuthGroups as ShieldAuthGroups;

class AuthGroups extends ShieldAuthGroups
{
    /**
     * --------------------------------------------------------------------
     * Default Group
     * --------------------------------------------------------------------
     * The group that a newly registered user is added to.
     */
    public string $defaultGroup = 'user';

    /**
     * --------------------------------------------------------------------
     * Groups
     * --------------------------------------------------------------------
     * An associative array of the available groups in the system, where the keys
     * are the group names and the values are arrays of the group info.
     *
     * Whatever value you assign as the key will be used to refer to the group
     * when using functions such as:
     *      $user->addGroup('superadmin');
     *
     * @var array<string, array<string, string>>
     *
     * @see https://codeigniter4.github.io/shield/quick_start_guide/using_authorization/#change-available-groups for more info
     */
    public array $groups = [
        // 'super admin' => [
        //     'title'       => 'Super Admin',
        //     'description' => 'Complete control of the site.',
        // ],
        'admin' => [
            'title'       => 'Admin',
            'description' => 'Day to day administrators of the site.',
        ],
        'branch admin' => [
            'title'       => 'Branch Admin',
            'description' => 'Campus administrators of the site.',
        ],
        // 'developer' => [
        //     'title'       => 'Developer',
        //     'description' => 'Site programmers.',
        // ],
        'adviser' => [
            'title'       => 'Adviser',
            'description' => 'Event ticket registrants and validators.',
        ],
        // 'user' => [
        //     'title'       => 'User',
        //     'description' => 'General users of the site. Often customers.',
        // ],
        // 'beta' => [
        //     'title'       => 'Beta User',
        //     'description' => 'Has access to beta-level features.',
        // ],
    ];

    /**
     * --------------------------------------------------------------------
     * Permissions
     * --------------------------------------------------------------------
     * The available permissions in the system.
     *
     * If a permission is not listed here it cannot be used.
     */
    public array $permissions = [
        'admin.access'        => 'Can access the sites admin area',
        'admin.settings'      => 'Can access the main site settings',
        'admin.purge'         => 'Can permanently delete an entity',
        'beta.access'         => 'Can access beta-level features',

        // superadmin
        'super.access'        => 'Can access all modules',

        // user
        'users.manage'        => 'Can manage other users and admins',
        'users.manage-users'  => 'Can only manage end users',
        'users.create'        => 'Can create new non-admin users',
        'users.edit'          => 'Can edit existing non-admin users',
        'users.delete'        => 'Can delete existing non-admin users',

        // branch
        'branches.manage'     => 'Can manage branch module',
        'branches.create'     => 'Can create new branch',
        'branches.edit'       => 'Can edit existing branch',
        'branches.delete'     => 'Can delete existing branch module',

        // event
        'events.manage'       => 'Can manage event module',
        'events.create'       => 'Can create new event',
        'events.edit'         => 'Can edit existing event',
        'events.delete'       => 'Can delete existing event',

        // ticket
        'tickets.manage'      => 'Can manage ticket module',
        'tickets.create'      => 'Can create new ticket',
        'tickets.edit'        => 'Can edit existing ticket',
        'tickets.delete'      => 'Can delete existing ticket',
        'tickets.validate'    => 'Can validate existing ticket',
        'tickets.view-all'    => 'Can view all tickets',
        'tickets.view-branch' => 'Can view all tickets',

        // log
        'logs.manage'         => 'Can manage log module',
        'logs.delete'         => 'Can manage log module',

        // dashboard (belongs to admin.access)
        'dashboard.access'    => 'Can access the dashboard',
    ];

    /**
     * --------------------------------------------------------------------
     * Permissions Matrix
     * --------------------------------------------------------------------
     * Maps permissions to groups.
     *
     * This defines group-level permissions.
     */
    public array $matrix = [
        'super admin' => [
            // 'admin.*',
            // 'users.*',
            // 'beta.*',
            'super.access',
        ],
        'admin' => [
            'admin.*',
            'beta.access',
            'users.*',
            'branches.*',
            'events.*',
            'tickets.*',
            'logs.*',
        ],
        'branch admin' => [
            'admin.access',
            'tickets.manage',
            'tickets.create',
            'tickets.edit',
            'tickets.delete',
            'tickets.validate',
            'tickets.view-branch',
            'logs.*',
        ],
        'developer' => [
            'admin.access',
            'admin.settings',
            'users.create',
            'users.edit',
            'beta.access',
        ],
        'adviser' => [
            'tickets.manage',
            'tickets.create',
            'tickets.edit',
            'tickets.validate'
        ],
        'user' => [],
        'beta' => [
            'beta.access',
        ],
    ];
}
