<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\TicketModel;
use CodeIgniter\HTTP\ResponseInterface;
use Config\Database;
use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Shield\Entities\User;

class DashboardController extends BaseController
{
    protected bool $isAjaxProcess = true;

    protected string $dir = "dashboard";

    protected array $data = [
        "searchbar" => false,
        "statusbar" => false,
        "module"    => "Dashboard",
    ];

    // Models
    protected ?TicketModel $tickets = null;

    // Entities
    protected ?User $user = null;

    public function __construct()
    {
        helper(["form", "input", "array"]); // $fizz = dot_array_search('foo.buzz.fizz', $data);

        if (!$this->user = auth()->user()) {
            throw PageNotFoundException::forPageNotFound();
        }
    }

    public function index()
    {
        if (!$this->user->can('super.access', 'admin.access')) {
            throw PageNotFoundException::forPageNotFound();
        }

        if ($this->isAjaxProcess) {
            return view("{$this->dir}/ajax/index", $this->data);
        }

        return view("{$this->dir}/post/index", $this->data);
    }

    public function fetchData()
    {
        if (!$this->user->can('super.access', 'admin.access')) {
            throw PageNotFoundException::forPageNotFound();
        }

        $db         = Database::connect();
        $branch     = $this->request->getVar('branch');
        $tickets    = $db->table('tickets');

        $tickets->join('events', 'events.id = tickets.event_id');
        $tickets->where('events.active', true);

        if (!empty($branch)) {
            $tickets->where('tickets.branch_id', $branch);
        }

        $arrivedTemp        = clone $tickets;
        $notArriveTemp      = clone $tickets;

        $data['total']      = $tickets->countAllResults();
        $data['notArrived'] = $arrivedTemp->where('tickets.date_attend IS NULL')->countAllResults();
        $data['arrivals']   = $notArriveTemp->where('tickets.date_attend IS NOT NULL')->countAllResults();

        return $this->response->setJSON($data);
    }

    /**
     * Gets the ticket provider
     */
    protected function getTicketProvider(): TicketModel
    {
        if ($this->tickets === null) {
            $this->tickets = new TicketModel();
        }

        return $this->tickets;
    }
}
