<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateBranchTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'            => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'auto_increment'    => true,
            ],
            'branch_code'   => [
                'type'              => 'VARCHAR',
                'constraint'        => 20,
                'null'              => true,
            ],
            'branch_name'   => [
                'type'              => 'VARCHAR',
                'constraint'        => 30,
                'null'              => true,
            ],
            'active'        => [
                'type'              => 'TINYINT',
                'constraint'        => 1,
                'default'           => 0,
            ],
            'created_by'    => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
            ],
            'created_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
            'updated_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
            'deleted_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->addUniqueKey('branch_code');
        $this->forge->addForeignKey('created_by', 'users', 'id', 'CASCADE', 'SET NULL');
        $this->forge->createTable('branches');
    }

    public function down()
    {
        $this->forge->dropTable('branches');
    }
}
