<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateScheduleTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'            => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'auto_increment'    => true,
            ],
            'event_id'      => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
            ],
            'branch_id'     => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
            ],
            'start_date'    => [
                'type'              => 'DATETIME',
                'null'              => true,
            ],
            'end_date'      => [
                'type'              => 'DATETIME',
                'null'              => true,
            ],
            'active'        => [
                'type'              => 'TINYINT',
                'constraint'        => 1,
                'default'           => 0,
            ],
            'created_by'    => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
            ],
            'created_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
            'updated_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
            'deleted_at'     => [
                'type'              => 'datetime',
                'null'              => true
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('event_id', 'events', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('branch_id', 'branches', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('created_by', 'users', 'id', 'CASCADE', 'SET NULL');
        $this->forge->createTable('schedules');
    }

    public function down()
    {
        $this->forge->dropTable('schedules');
    }
}
