<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Forge;
use CodeIgniter\Database\Migration;

class AddProfileColumnToUsersTable extends Migration
{
    /**
     * @var string[]
     */
    private array $tables;

    public function __construct(?Forge $forge = null)
    {
        parent::__construct($forge);

        /** @var \Config\Auth $authConfig */
        $authConfig   = config('Auth');
        $this->tables = $authConfig->tables;
    }

    public function up()
    {
        $fields = [
            'branch_id'     => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
                'after'             => 'username',
            ],
            'first_name'    => [
                'type'              => 'VARCHAR',
                'constraint'        => 50,
                'null'              => true,
                'after'             => 'branch_id',
            ],
            'last_name'     => [
                'type'              => 'VARCHAR',
                'constraint'        => 50,
                'null'              => true,
                'after'             => 'first_name',
            ],
            'middle_name'   => [
                'type'              => 'VARCHAR',
                'constraint'        => 50,
                'null'              => true,
                'after'             => 'last_name',
            ],
            'phone_number'  => [
                'type'              => 'VARCHAR',
                'constraint'        => 20,
                'null'              => true,
                'after'             => 'middle_name',
            ],
            'created_by'    => [
                'type'              => 'INT',
                'constraint'        => 11,
                'unsigned'          => true,
                'null'              => true,
                'after'             => 'phone_number',
            ],
        ];

        $this->forge->addForeignKey('branch_id', 'branches', 'id', 'CASCADE', 'SET NULL');
        $this->forge->addForeignKey('created_by', 'users', 'id', 'CASCADE', 'SET NULL');
        $this->forge->addColumn($this->tables['users'], $fields);
    }

    public function down()
    {
        $fields = [
            'branch_id',
            'first_name',
            'last_name',
            'middle_name',
            'phone_number',
            'created_by',
        ];

        $this->forge->dropColumn($this->tables['users'], $fields);
    }
}
