<?php

use CodeIgniter\Pager\Pager;

if (!function_exists('generatePaginationLinks')) {
    /**
     * Clean input data by setting fields with only spaces to null.
     *
     * @param Pager|string|mixed $pager
     * @param int $currentPage
     * @param int $totalPages
     * @param int $neighbours
     * @return array
     */
    function generatePaginationLinks($pager, $currentPage, $totalPages, $neighbours = 2)
    {
        $links = [];

        // First page link
        if ($currentPage == 1) {
            $links[] = [
                'title' => 1,
                'uri' => $pager->getFirst(),
                'active' => true,
            ];
        } else {
            $links[] = [
                'title' => 1,
                'uri' => $pager->getFirst(),
                'active' => false,
            ];
        }

        if ($totalPages > 1) {

            // Add "..." before current page's neighbours if needed
            if ($currentPage - $neighbours > 2) {
                $links[] = [
                    'title' => '...',
                    'uri' => '#',
                    'active' => false,
                ];
            }

            // Pages around the current page
            for ($i = max(2, $currentPage - $neighbours); $i <= min($totalPages - 1, $currentPage + $neighbours); $i++) {
                $links[] = [
                    'title' => $i,
                    'uri' => $pager->links()[$i - 1]['uri'],
                    'active' => ($i == $currentPage),
                ];
            }

            // Add "..." after current page's neighbours if needed
            if ($currentPage + $neighbours < $totalPages - 1) {
                $links[] = [
                    'title' => '...',
                    'uri' => '#',
                    'active' => false,
                ];
            }

            // Last page link
            if ($currentPage == $totalPages) {
                $links[] = [
                    'title' => $totalPages,
                    'uri' => $pager->getLast(),
                    'active' => true,
                ];
            } else {
                $links[] = [
                    'title' => $totalPages,
                    'uri' => $pager->getLast(),
                    'active' => false,
                ];
            }
        }

        return $links;
    }
}
