<?php

if (!function_exists('admin_url')) {
    /**
     * URL with admin as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function admin_url($relativePath = null): string
    {
        return _path_maker(ADMIN_SEGMENT, $relativePath);
    }
}

if (!function_exists('branch_url')) {
    /**
     * URL with branch as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function branch_url($relativePath = null): string
    {
        return _path_maker(BRANCH_SEGMENT, $relativePath);
    }
}

if (!function_exists('event_url')) {
    /**
     * URL with event as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function event_url(string $relativePath = '')
    {
        return _path_maker(EVENT_SEGMENT, $relativePath);
    }
}

if (!function_exists('log_url')) {
    /**
     * URL with log as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function log_url(string $relativePath = '')
    {
        return _path_maker(LOG_SEGMENT, $relativePath);
    }
}

if (!function_exists('my_url')) {
    /**
     * URL with `my` as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function my_url($relativePath = null): string
    {
        return _path_maker(MY_SEGMENT, $relativePath);
    }
}

if (!function_exists('profile_url')) {
    /**
     * URL with profile as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function profile_url($relativePath = null): string
    {
        return my_url(PROFILE_SEGMENT . ($relativePath ? "/{$relativePath}" : ""));
    }
}

if (!function_exists('reports_url')) {
    /**
     * URL with reports as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function reports_url($relativePath = null): string
    {
        return _path_maker(REPORT_SEGMENT, $relativePath);
    }
}

if (!function_exists('settings_url')) {
    /**
     * URL with settings as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function settings_url($relativePath = null): string
    {
        return my_url(SETTINGS_SEGMENT . ($relativePath ? "/{$relativePath}" : ""));
    }
}

if (!function_exists('ticket_url')) {
    /**
     * URL with ticket as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function ticket_url($relativePath = null): string
    {
        return _path_maker(TICKET_SEGMENT, $relativePath);
    }
}

if (!function_exists('user_url')) {
    /**
     * URL with user as secondary segment for easier redirecting.
     * 
     * @param array|string|null $relativePath
     */
    function user_url($relativePath = null): string
    {
        return _path_maker(USER_SEGMENT, $relativePath);
    }
}

if (!function_exists('_path_maker')) {
    /**
     * Checks string or array path and returns a valid url.
     * 
     * @param string|null $mainSegment
     * @param array|string|null $relativePath
     */
    function _path_maker($mainSegment = null, $relativePath = null)
    {
        if (is_array($relativePath)) {
            $segments = array_merge([$mainSegment], $relativePath);
            $segments = array_filter($segments);
        } else {
            $segments = $mainSegment . ($relativePath ? '/' . $relativePath : '');
        }

        return base_url($segments);
    }
}
