<?= $this->extend('layouts/blank') ?>

<?= $this->section('title') ?> <?= lang('Auth.register') ?> <?= $this->endSection() ?>

<?= $this->section('pageStyles') ?>

<link rel="stylesheet" href="/assets/template/vendor/css/pages/page-auth.css" />

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner" style="max-width: 900px;">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center gap-3 mb-4">
                        <img src="/assets/img/au_logo.png" alt="AU Logo" width="64" />
                        <div class="d-flex flex-column">
                            <h2 class="fw-bold mb-0">auticket</h2>
                            <h6 class="mb-0">Event Management System</h6>
                        </div>
                    </div>
                    <form class="mb-3" action="<?= url_to('register') ?>" method="POST">
                        <?= csrf_field() ?>
                        <?php $errors = is_array(session('errors')) ? session('errors') : [] ?>

                        <hr class="my-4 mx-n4">
                        <h6>1. User's Name</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="first_name">First Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="first_name" class="form-control" id="first_name" placeholder="Enter first name" value="<?= old('first_name') ?>" autofocus />
                                <small class="text-danger"><?= dot_array_search('first_name', $errors) ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="last_name">Last Name</label>
                            <div class="col-sm-9">
                                <input type="text" name="last_name" class="form-control" id="last_name" placeholder="Enter last name" value="<?= old('last_name') ?>" />
                                <small class="text-danger"><?= dot_array_search('last_name', $errors) ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="middle_name">Middle Name (Optional)</label>
                            <div class="col-sm-9">
                                <input type="text" name="middle_name" class="form-control" id="middle_name" placeholder="Enter middle name (optional)" value="<?= old('middle_name') ?>" />
                                <small class="text-danger"><?= dot_array_search('middle_name', $errors) ?></small>
                            </div>
                        </div>

                        <hr class="my-4 mx-n4">
                        <h6>2. Login & Contact</h6>

                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="username">Username</label>
                            <div class="col-sm-9">
                                <input type="text" name="username" class="form-control" id="username" placeholder="Enter username" value="<?= old('username') ?>" />
                                <small class="text-danger"><?= dot_array_search('username', $errors) ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="email">Email Address</label>
                            <div class="col-sm-9">
                                <input type="email" name="email" class="form-control" id="email" placeholder="Enter email" value="<?= old('email') ?>" />
                                <small class="text-danger"><?= dot_array_search('email', $errors) ?></small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-3 col-form-label" for="phone_number">Contact Number (Optional)</label>
                            <div class="col-sm-9">
                                <input type="text" name="phone_number" class="form-control" id="phone_number" placeholder="Enter contact number (optional)" value="<?= old('phone_number') ?>" />
                                <small class="text-danger"><?= dot_array_search('phone_number', $errors) ?></small>
                            </div>
                        </div>

                        <div class="row mb-3 form-password-toggle">
                            <label class="col-sm-3 col-form-label" for="password">Password</label>
                            <div class="col-sm-9">
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password" class="form-control" name="password" placeholder="Enter your password" aria-describedby="password" />
                                    <span class="input-group-text"><i class="bx bx-hide"></i></span>
                                </div>
                                <small class="text-danger"><?= dot_array_search('password', $errors) ?></small>
                            </div>
                        </div>
                        <div class="row mb-3 form-password-toggle">
                            <label class="col-sm-3 col-form-label" for="password_confirm">Confirm Password</label>
                            <div class="col-sm-9">
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password_confirm" class="form-control" name="password_confirm" placeholder="Confirm password" aria-describedby="password" />
                                    <span class="input-group-text"><i class="bx bx-hide"></i></span>
                                </div>
                                <small class="text-danger"><?= dot_array_search('password_confirm', $errors) ?></small>
                            </div>
                        </div>

                        <div class="row justify-content-end" id="actionButtons">
                            <div class="col-sm-9">
                                <div class="d-flex align-items-center flex-wrap gap-3">
                                    <button type="submit" class="btn btn-danger d-flex align-items-center gap-2">
                                        <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                        Register
                                    </button>
                                    <p class="m-0">
                                        <span><?= lang('Auth.haveAccount') ?></span>
                                        <a href="<?= url_to('login') ?>">
                                            <span><?= lang('Auth.login') ?></span>
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>