<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> New Branch <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <h5 class="card-header">Add New Branch</h5>
            <div class="card-body">
                <form action="">
                    <?= csrf_field() ?>
                    <input type="hidden" name="id" value="">

                    <p id="description">
                        <span class="helper text-secondary">Please fill out the required fields to add new branch.</span>
                        <span class="error text-danger"></span>
                    </p>

                    <hr class="my-4 mx-n4">
                    <h6>1. Branch Info</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="branch_code">Branch Code</label>
                        <div class="col-sm-9">
                            <input type="text" name="branch_code" class="form-control" id="branch_code" placeholder="Enter branch code" value="<?= old('branch_code') ?>" autofocus />
                            <small class="text-danger input-error" data-for="branch_code"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="branch_code"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="branch_name">Branch Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="branch_name" class="form-control" id="branch_name" placeholder="Enter branch name" value="<?= old('branch_name') ?>" />
                            <small class="text-danger input-error" data-for="branch_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="branch_name"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="active">Active</label>
                        <div class="col-sm-9">
                            <div class="form-check form-switch">
                                <input type="checkbox" name="active" class="form-check-input" role="switch" id="active" value="1" <?= old('active') ? 'checked' : '' ?> />
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-end" id="actionButtons">
                        <div class="col-sm-9">
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-outline-secondary" data-toggle="cancel" disabled>
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-primary d-flex align-items-center gap-2" disabled>
                                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    Create
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/js/swal2_init.js"></script>
<script src="/assets/js/form_helper.js"></script>
<script type="text/javascript">
    $(document).ready(function() {

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            let data = response.branch;
            setCancelButton(data, "<?= branch_url() ?>");
            setRequest(data, "<?= branch_url("store") ?>", "<?= branch_url() ?>");
        });

    });
</script>

<?= $this->endSection() ?>

<?= $this->endSection() ?>