<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Dashboard <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row gy-4">
    <div class="col-md-7">
        <div class="card h-100">
            <div class="card-body">
                <div class="d-flex align-items-center gap-2 me-3">
                    <?php $event = $event ?? model('EventModel')->findActiveEvent() ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" style="fill: <?= $event ? 'rgba(1, 78, 168, 1)' : 'rgba(217, 49, 38, 1)' ?>;transform: ;msFilter:;">
                        <path d="m9.981 14.811-.467 2.726 2.449-1.287 2.449 1.287-.468-2.726 1.982-1.932-2.738-.398L11.963 10l-1.225 2.481L8 12.879z"></path>
                        <path d="M19 4h-2V2h-2v2H9V2H7v2H5c-1.103 0-2 .897-2 2v14c0 1.103.897 2 2 2h14c1.103 0 2-.897 2-2V6c0-1.103-.897-2-2-2zm.002 16H5V8h14l.002 12z"></path>
                    </svg>
                    <div>
                        <h6 class="mt-1 mb-2">Event:</h6>
                        <?php if ($event) : ?>
                            <h5 class="text-primary m-0"><?= esc($event->event_name) ?></h5>
                        <?php else : ?>
                            <h5 class="text-danger m-0">There is no currently active event right now.</h5>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-5">
        <div class="card h-100">
            <div class="card-body">
                <div class="d-flex align-items-center gap-2 me-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" style="fill: rgba(1, 78, 168, 1);transform: ;msFilter:;">
                        <path d="m12 17 1-2V9.858c1.721-.447 3-2 3-3.858 0-2.206-1.794-4-4-4S8 3.794 8 6c0 1.858 1.279 3.411 3 3.858V15l1 2zM10 6c0-1.103.897-2 2-2s2 .897 2 2-.897 2-2 2-2-.897-2-2z"></path>
                        <path d="m16.267 10.563-.533 1.928C18.325 13.207 20 14.584 20 16c0 1.892-3.285 4-8 4s-8-2.108-8-4c0-1.416 1.675-2.793 4.267-3.51l-.533-1.928C4.197 11.54 2 13.623 2 16c0 3.364 4.393 6 10 6s10-2.636 10-6c0-2.377-2.197-4.46-5.733-5.437z"></path>
                    </svg>
                    <div>
                        <h6 class="mt-1 mb-2">Branch:</h6>
                        <select class="form-select" data-action="filter" name="branch" id="branch">
                            <option value="">All Branch</option>
                            <?php foreach (model('BranchModel')->findAll() as $branch) : ?>
                                <option value="<?= $branch->id ?>"><?= $branch->branch_name ?></option>
                            <?php endforeach ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-5 col-lg-4">
        <div class="row gy-2">
            <div class="col-12">
                <div class="card bg-danger text-white h-100">
                    <div class="card-body">
                        <h6 class="text-white mt-2 mb-2">Arrivals</h6>
                        <div class="d-flex align-items-center gap-3 me-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" style="fill: rgba(255, 255, 255, 1);transform: ;msFilter:;">
                                <path d="M12 3c-4.625 0-8.442 3.507-8.941 8.001H10v-3l5 4-5 4v-3H3.06C3.56 17.494 7.376 21 12 21c4.963 0 9-4.037 9-9s-4.037-9-9-9z"></path>
                            </svg>
                            <h2 class="text-white m-0" id="arrivals">...</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card bg-danger text-white h-100">
                    <div class="card-body">
                        <h6 class="text-white mt-2 mb-2">Not Arrived</h6>
                        <div class="d-flex align-items-center gap-3 me-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" style="fill: rgba(255, 255, 255, 1);transform: ;msFilter:;">
                                <path d="M19 13V4c0-1.103-.897-2-2-2H7c-1.103 0-2 .897-2 2v9a1 1 0 0 0-1 1v8h2v-5h12v5h2v-8a1 1 0 0 0-1-1zm-2-9v9h-2V4h2zm-4 0v9h-2V4h2zM7 4h2v9H7V4z"></path>
                            </svg>
                            <h2 class="text-white m-0" id="notArrived">...</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card bg-danger text-white h-100">
                    <div class="card-body">
                        <h6 class="text-white mt-2 mb-2">Total Tickets</h6>
                        <div class="d-flex align-items-center gap-3 me-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" style="fill: rgba(255, 255, 255, 1);transform: ;msFilter:;">
                                <path d="M17.004 5H9c-1.838 0-3.586.737-4.924 2.076C2.737 8.415 2 10.163 2 12c0 1.838.737 3.586 2.076 4.924C5.414 18.263 7.162 19 9 19h8v-2H9c-1.303 0-2.55-.529-3.51-1.49C4.529 14.55 4 13.303 4 12c0-1.302.529-2.549 1.49-3.51C6.45 7.529 7.697 7 9 7h8V6l.001 1h.003c.79 0 1.539.314 2.109.886.571.571.886 1.322.887 2.116a2.966 2.966 0 0 1-.884 2.11A2.988 2.988 0 0 1 17 13H9a.99.99 0 0 1-.698-.3A.991.991 0 0 1 8 12c0-.252.11-.507.301-.698A.987.987 0 0 1 9 11h8V9H9c-.79 0-1.541.315-2.114.889C6.314 10.461 6 11.211 6 12s.314 1.54.888 2.114A2.974 2.974 0 0 0 9 15h8.001a4.97 4.97 0 0 0 3.528-1.473 4.967 4.967 0 0 0-.001-7.055A4.95 4.95 0 0 0 17.004 5z"></path>
                            </svg>
                            <h2 class="text-white m-0" id="totalTickets">...</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-md-7 col-lg-8">
        <div class="card h-100">
            <div class="card-body position-relative">
                <canvas id="myChart" width="400" height="200"></canvas>
            </div>
        </div>
    </div>
</div>
<div class="row">

</div>

<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script type="text/javascript">
    $(document).ready(function() {

        let fetchInterval;
        const ctx = document.getElementById('myChart').getContext('2d');
        const myChart = new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: ['Arrivals', 'Not Arrived'],
                datasets: [{
                    label: 'Tickets',
                    data: [0, 0], // Initial dummy data
                    backgroundColor: [
                        'rgba(218, 40, 28, 1)',
                        'rgba(1, 78, 168, 1)',
                        'rgba(53, 58, 64, 1)',
                    ],
                    borderColor: [
                        '#fff',
                        '#fff'
                    ],
                    borderWidth: 5,
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    title: {
                        display: true,
                        text: 'Event Ticket Status'
                    },
                    legend: {
                        position: 'top',
                    },
                    interaction: {
                        mode: 'index',
                        intersect: false
                    },
                }
            }
        });

        function fetchDataAndUpdateChart(branchFilter = '') {
            $.ajax({
                url: '<?= base_url(DASHBOARD_SEGMENT . '/fetchData') ?>',
                method: 'GET',
                data: {
                    branch: branchFilter
                },
                dataType: 'json',
                success: function(data) {
                    // console.log(data);
                    updateChart(data);
                    resetFetchInterval();
                },
                error: function(error) {
                    console.error('Error fetching the data:', error);
                }
            });
        }

        function updateChart(data) {
            $('#arrivals').text(data.arrivals);
            $('#notArrived').text(data.notArrived);
            $('#totalTickets').text(data.total);
            // emptyVal = Number(data.total) === 0 ? 1 : 0;
            myChart.data.datasets[0].data = [
                Number(data.arrivals).toLocaleString("en"),
                Number(data.notArrived).toLocaleString("en"),
                // Number(emptyVal).toLocaleString("en"),
            ];
            myChart.update();
        }

        function resetFetchInterval() {
            if (fetchInterval) {
                clearInterval(fetchInterval);
            }
            fetchInterval = setInterval(function() {
                fetchDataAndUpdateChart($('#branch').val());
            }, 10000);
        }

        fetchDataAndUpdateChart($('#branch').val());

        $('#branch').change(function() {
            fetchDataAndUpdateChart($(this).val());
        });
    });
</script>

<?= $this->endSection() ?>