<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> New Event <?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-xxl">
        <div class="card mb-4">
            <h5 class="card-header">Add New Event</h5>
            <div class="card-body">
                <form action="">
                    <?= csrf_field() ?>
                    <input type="hidden" name="id" value="">

                    <p id="description">
                        <span class="helper text-secondary">Please fill out the required fields to add new event.</span>
                        <span class="error text-danger"></span>
                    </p>

                    <hr class="my-4 mx-n4">
                    <h6>1. Event Info</h6>

                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="event_code">Event Code</label>
                        <div class="col-sm-9">
                            <input type="text" name="event_code" class="form-control" id="event_code" placeholder="Enter event code" value="<?= old('event_code') ?>" autofocus />
                            <small class="text-danger input-error" data-for="event_code"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="event_code"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="event_name">Event Name</label>
                        <div class="col-sm-9">
                            <input type="text" name="event_name" class="form-control" id="event_name" placeholder="Enter event name" value="<?= old('event_name') ?>" />
                            <small class="text-danger input-error" data-for="event_name"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="event_name"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="event_description">Description (Optional)</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" name="event_description" id="event_description" rows="3" placeholder="Enter a brief description of the event (optional)..."><?= old('event_description') ?></textarea>
                            <small class="text-danger input-error" data-for="event_description"></small>
                            <small class="text-secondary fst-italic input-helper" data-for="event_description"></small>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label class="col-sm-3 col-form-label" for="active">Active</label>
                        <div class="col-sm-9">
                            <div class="form-check form-switch">
                                <input type="checkbox" name="active" class="form-check-input" role="switch" id="active" value="1" <?= old('active') ? 'checked' : '' ?> />
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-end" id="actionButtons">
                        <div class="col-sm-9">
                            <div class="d-flex align-items-center gap-2">
                                <button type="button" class="btn btn-outline-secondary" data-toggle="cancel" disabled>
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-primary d-flex align-items-center gap-2" disabled>
                                    <div class="spinner-border spinner-border-sm text-light d-none" id="submit_spinner" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    Create
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->section('pageScripts') ?>

<!--<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>-->
<script src="/assets/vendor/SweetAlert2/swal2.js"></script>
<script src="/assets/js/swal2_init.js"></script>
<script src="/assets/js/form_helper.js"></script>
<script type="text/javascript">
    $(document).ready(function() {

        $.getJSON('/assets/json/content/swal_text.json', function(response) {
            let data = response.event;
            setCancelButton(data, "<?= event_url() ?>");
            setRequest(data, "<?= event_url("store") ?>", "<?= event_url() ?>");
        });

    });
</script>

<?= $this->endSection() ?>

<?= $this->endSection() ?>