<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?> Branch List <?= $this->endSection() ?>

<?= $this->section('content') ?>

<?php if (session()->getFlashdata('success')) : ?>

    <div class="alert alert-info alert-dismissible my-3" role="alert">
        <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>

<?php endif ?>

<?php if (session()->getFlashdata('error')) : ?>

    <div class="alert alert-danger alert-dismissible my-3" role="alert">
        <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>

<?php endif ?>

<div class="card">
    <div class="card-header row align-items-center">
        <div class="col-md-auto text-center">
            <h4 class="card-title m-0">Event Management</h4>
        </div>
        <div class="col-md-auto ms-auto pt-3 pt-md-0">
            <div class="row flex-wrap">
                <form class="col" method="post">
                    <div class="input-group input-group-merge">
                        <button type="submit" class="input-group-text">
                            <i class="bx bx-search"></i>
                        </button>
                        <input type="search" name="search" class="form-control" placeholder="Search..." aria-label="Search..." value="<?= $search ?? '' ?>" autofocus />
                    </div>
                </form>
                <div class="col-auto">
                    <a href="<?= base_url('event/create') ?>" class="btn btn-primary" tabindex="0">
                        <span><i class="bx bx-plus me-sm-1"></i></span>
                        <span class="d-none d-sm-inline-block">Add New Event</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!--<div class="table-responsive text-nowrap">-->
    <div class="table-responsive text-nowrap">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Event Name</th>
                    <th>Description</th>
                    <th>Active</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>

                <?php if (!empty($events)) : foreach ($events as $event) : ?>

                        <tr>
                            <td>
                                <i class="fab fa-angular fa-lg text-danger me-3"></i>
                                <strong><?= $event['event_code'] ?></strong>
                            </td>
                            <td><?= $event['event_name'] ?></td>
                            <td><?= $event['event_description'] ?></td>
                            <td>
                                <?php if ($event['active']) : ?>

                                    <i class="bx bx-check text-success"></i>

                                <?php else : ?>

                                    <i class="bx bx-x text-danger"></i>

                                <?php endif ?>
                            </td>
                            <td>
                                <div class="dropdown position-static">
                                    <a role="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end m-0">
                                        <li>
                                            <a class="dropdown-item" href="event/edit/<?= $event['id'] ?>">
                                                <i class="bx bx-edit-alt me-1"></i>
                                                Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="event/delete/<?= $event['id'] ?>">
                                                <i class="bx bx-trash me-1"></i>
                                                Delete
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>

                    <?php endforeach;
                else : ?>

                    <tr>
                        <td colspan="5" class="text-danger text-center">No data found.</td>
                    </tr>

                <?php endif; ?>

            </tbody>
        </table>
    </div>
    <div class="card-footer pt-3 pb-1">
        <div id="pagination-links">
            <?= $pagination_link ?? '' ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>